/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.advnavigator;

import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.client.advnavigator.Navigator;
import org.guvnor.structure.client.advnavigator.NavigatorOptions;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.guvnor.structure.navigator.DataContent;
import org.guvnor.structure.navigator.FileNavigatorService;
import org.guvnor.structure.navigator.NavigatorContent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.tree.FSTreeItem;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.type.DotResourceTypeDefinition;

@Dependent
@Named(value="TreeNav")
public class TreeNavigator
extends Composite
implements Navigator {
    private static final String LAZY_LOAD = "Loading...";
    @Inject
    private DotResourceTypeDefinition hiddenTypeDef;
    @Inject
    private Caller<FileNavigatorService> navigatorService;
    private NavigatorOptions options = NavigatorOptions.DEFAULT;
    private final Tree tree = new Tree();
    private ParameterizedCommand<Path> fileActionCommand = null;

    @PostConstruct
    public void init() {
        this.tree.addStyleName(NavigatorResources.INSTANCE.css().treeNav());
        this.initWidget((Widget)this.tree);
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<FSTreeItem>(){

            public void onOpen(OpenEvent<FSTreeItem> event) {
                if (TreeNavigator.this.needsLoading((FSTreeItem)event.getTarget()) && ((FSTreeItem)event.getTarget()).getUserObject() instanceof Path) {
                    TreeNavigator.this.loadContent(new TreeNavigatorItemImpl((FSTreeItem)event.getTarget()), (Path)((FSTreeItem)event.getTarget()).getUserObject());
                }
            }
        });
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<FSTreeItem>(){

            public void onSelection(SelectionEvent<FSTreeItem> event) {
                Object userObject;
                if (TreeNavigator.this.fileActionCommand != null && (userObject = ((FSTreeItem)event.getSelectedItem()).getUserObject()) != null && userObject instanceof Path) {
                    TreeNavigator.this.fileActionCommand.execute((Object)((Path)userObject));
                }
            }
        });
    }

    private void loadContent(final Navigator.NavigatorItem parent, Path path) {
        if (path != null) {
            ((FileNavigatorService)this.navigatorService.call((RemoteCallback)new RemoteCallback<NavigatorContent>(){

                public void callback(NavigatorContent response) {
                    for (DataContent dataContent : response.getContent()) {
                        if (dataContent.isDirectory()) {
                            if (!TreeNavigator.this.options.showDirectories()) continue;
                            parent.addDirectory(dataContent.getPath());
                            continue;
                        }
                        if (!TreeNavigator.this.options.showFiles()) continue;
                        if (!TreeNavigator.this.options.showHiddenFiles() && !TreeNavigator.this.hiddenTypeDef.accept(dataContent.getPath())) {
                            parent.addFile(dataContent.getPath());
                            continue;
                        }
                        if (!TreeNavigator.this.options.showHiddenFiles()) continue;
                        parent.addFile(dataContent.getPath());
                    }
                }
            })).listContent(path);
        }
    }

    @Override
    public void loadContent(Path path) {
        TreeNavigatorItemImpl parent = new TreeNavigatorItemImpl(new FSTreeItem(FSTreeItem.FSType.FOLDER, path.getFileName()));
        this.tree.addItem((TreeItem)parent.parent);
        this.loadContent(parent, path);
    }

    private boolean needsLoading(FSTreeItem item) {
        return item.getChildCount() == 1 && LAZY_LOAD.equals(((FSTreeItem)item.getChild(0)).getText());
    }

    private class TreeNavigatorItemImpl
    implements Navigator.NavigatorItem {
        private final FSTreeItem parent;

        TreeNavigatorItemImpl(FSTreeItem treeItem) {
            this.parent = (FSTreeItem)PortablePreconditions.checkNotNull((String)"parent", (Object)treeItem);
        }

        @Override
        public void addDirectory(Path child) {
            this.checkCleanupLoading();
            FSTreeItem newDirectory = this.parent.addItem(FSTreeItem.FSType.FOLDER, child.getFileName());
            newDirectory.addItem(FSTreeItem.FSType.LOADING, TreeNavigator.LAZY_LOAD);
            newDirectory.setUserObject((Object)child);
        }

        @Override
        public void addFile(Path child) {
            this.checkCleanupLoading();
            FSTreeItem newFile = this.parent.addItem(FSTreeItem.FSType.ITEM, child.getFileName());
            newFile.setUserObject((Object)child);
        }

        private void checkCleanupLoading() {
            if (this.parent.getChild(0) != null && ((FSTreeItem)this.parent.getChild(0)).getUserObject() == null) {
                ((FSTreeItem)this.parent.getChild(0)).remove();
            }
        }
    }
}

