/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerPresenter;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerViewImpl;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.tree.FSTreeItem;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileExplorerViewImplTest {
    @Mock
    private FileExplorerPresenter presenter;
    @Mock
    private Tree<FSTreeItem> tree;
    private FSTreeItem item;
    private FileExplorerViewImpl view;

    @Before
    public void setUp() {
        this.view = new FileExplorerViewImpl(this.tree);
        ((Tree)Mockito.doAnswer(invocationOnMock -> {
            FSTreeItem item1 = (FSTreeItem)invocationOnMock.getArguments()[0];
            return item1;
        }).when(this.tree)).addItem((TreeItem)Mockito.any(FSTreeItem.class));
        this.view.init(this.presenter);
    }

    @Test
    public void checkItemsAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(FSTreeItem.FSType.ITEM, "file", (Path)Mockito.mock(Path.class)), new TreeItemData[0]);
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithNoChildrenAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(FSTreeItem.FSType.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData[0]);
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithExistingChildrenAreNotLazyLoaded() {
        this.item = this.newTreeItem(new TreeItemData(FSTreeItem.FSType.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData(FSTreeItem.FSType.ITEM, "file1", (Path)Mockito.mock(Path.class)), new TreeItemData(FSTreeItem.FSType.ITEM, "file2", (Path)Mockito.mock(Path.class)));
        Assert.assertFalse((boolean)this.view.needsLoading(this.item));
    }

    @Test
    public void checkFoldersWithLazyFlagAreLazyLoaded() {
        this.item = (FSTreeItem)Mockito.spy((Object)this.newTreeItem(new TreeItemData(FSTreeItem.FSType.FOLDER, "folder", (Path)Mockito.mock(Path.class)), new TreeItemData(FSTreeItem.FSType.ITEM, CommonConstants.INSTANCE.Loading(), (Path)Mockito.mock(Path.class))));
        FSTreeItem child = (FSTreeItem)Mockito.mock(FSTreeItem.class);
        Mockito.when((Object)this.item.getChild(Mockito.eq((int)0))).thenReturn((Object)child);
        Mockito.when((Object)child.getText()).thenReturn((Object)CommonConstants.INSTANCE.Loading());
        Assert.assertTrue((boolean)this.view.needsLoading(this.item));
    }

    private FSTreeItem newTreeItem(TreeItemData parent, TreeItemData ... children) {
        final ArrayList cti = new ArrayList();
        FSTreeItem item = new FSTreeItem(parent.type, parent.value){

            public int getChildCount() {
                return cti.size();
            }

            public FSTreeItem getChild(int i) {
                return (FSTreeItem)cti.get(i);
            }

            protected FSTreeItem makeChild(FSTreeItem.FSType type, final String value) {
                return new FSTreeItem(type, value){

                    public String getText() {
                        return value;
                    }
                };
            }
        };
        item.setUserObject((Object)parent.path);
        Arrays.asList(children).stream().forEach(c -> {
            FSTreeItem ti = item.addItem(c.type, c.value);
            ti.setUserObject((Object)c.path);
            cti.add(ti);
        });
        return item;
    }

    private class TreeItemData {
        FSTreeItem.FSType type;
        String value;
        Path path;

        TreeItemData(FSTreeItem.FSType type, String value, Path path) {
            this.type = type;
            this.value = value;
            this.path = path;
        }
    }
}

