/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.client.editors.repository.list.RepositoriesPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoriesView;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemView;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.spaces.Space;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoriesPresenterTest {
    private RepositoriesPresenter presenter;
    @Mock
    private RepositoriesView view;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private WorkspaceProjectContext projContext;
    @Mock
    private EventSourceMock<NotificationEvent> notification;
    private GuvnorStructureContext guvnorStructureContext;
    private Collection<Repository> repositories;
    @Mock
    private Path branchPath;
    private Repository r1;
    private Repository r2;
    private Repository r3;
    private Repository r4;
    @Mock
    private RepositoryItemView itemView1;
    @Mock
    private RepositoryItemView itemView2;
    @Mock
    private RepositoryItemView itemView3;
    @Mock
    private RepositoryItemView itemView4;
    private RepositoryItemPresenter itemPresenter1;
    private RepositoryItemPresenter itemPresenter2;
    private RepositoryItemPresenter itemPresenter3;
    private RepositoryItemPresenter itemPresenter4;
    private GuvnorStructureContextChangeHandler changeHandler;
    private GuvnorStructureContextChangeHandler.HandlerRegistration changeHandlerRegistration;
    private GuvnorStructureContextChangeHandler.HandlerRegistration removedChangeHandlerRegistration;

    @Before
    public void init() {
        this.r1 = this.createRepository("r1", "space");
        this.r2 = this.createRepository("r2", "space");
        this.r3 = this.createRepository("r3", "space");
        this.r4 = this.createRepository("r4", "space");
        OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Mockito.when((Object)ou.getName()).thenReturn((Object)"space");
        Mockito.when((Object)this.projContext.getActiveOrganizationalUnit()).thenReturn(Optional.of(ou));
        this.repositories = new ArrayList<Repository>();
        this.repositories.add(this.r1);
        this.repositories.add(this.r2);
        this.repositories.add(this.r3);
        this.guvnorStructureContext = new GuvnorStructureContext((Caller)new CallerMock((Object)this.repositoryService), this.projContext){

            public GuvnorStructureContextChangeHandler.HandlerRegistration addGuvnorStructureContextChangeHandler(GuvnorStructureContextChangeHandler handler) {
                RepositoriesPresenterTest.this.changeHandler = handler;
                RepositoriesPresenterTest.this.changeHandlerRegistration = super.addGuvnorStructureContextChangeHandler(handler);
                return RepositoriesPresenterTest.this.changeHandlerRegistration;
            }

            public void removeHandler(GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration) {
                RepositoriesPresenterTest.this.removedChangeHandlerRegistration = handlerRegistration;
                super.removeHandler(handlerRegistration);
            }
        };
        this.itemPresenter1 = this.createItemPresenter(this.itemView1, this.guvnorStructureContext, this.r1, "master");
        this.itemPresenter2 = this.createItemPresenter(this.itemView2, this.guvnorStructureContext, this.r2, "master");
        this.itemPresenter3 = this.createItemPresenter(this.itemView3, this.guvnorStructureContext, this.r3, "master");
        this.itemPresenter4 = this.createItemPresenter(this.itemView4, this.guvnorStructureContext, this.r4, "master");
        this.presenter = new RepositoriesPresenter(this.view, this.guvnorStructureContext);
        Mockito.when((Object)this.repositoryService.getRepositories((Space)Mockito.eq((Object)new Space("space")))).thenReturn(this.repositories);
        Mockito.when((Object)this.view.addRepository(this.r1, "master")).thenReturn((Object)this.itemPresenter1);
        Mockito.when((Object)this.view.addRepository(this.r2, "master")).thenReturn((Object)this.itemPresenter2);
        Mockito.when((Object)this.view.addRepository(this.r3, "master")).thenReturn((Object)this.itemPresenter3);
        Mockito.when((Object)this.view.addRepository(this.r4, "master")).thenReturn((Object)this.itemPresenter4);
        ((RepositoriesView)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new RuntimeException("Should remove a valid repository item.");
            }
        }).when((Object)this.view)).removeIfExists((RepositoryItemPresenter)Mockito.eq((Object)null));
    }

    @Test
    public void testSetHandlers() throws Exception {
        Assert.assertTrue((this.changeHandler == this.presenter ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveHandlers() throws Exception {
        Assert.assertTrue((this.removedChangeHandlerRegistration == null ? 1 : 0) != 0);
        this.presenter.shutdown();
        Assert.assertTrue((this.changeHandlerRegistration == this.removedChangeHandlerRegistration ? 1 : 0) != 0);
    }

    @Test
    public void testNewBranchTest() {
        GuvnorStructureContextChangeHandler handler = (GuvnorStructureContextChangeHandler)Mockito.mock(GuvnorStructureContextChangeHandler.class);
        this.guvnorStructureContext.addGuvnorStructureContextChangeHandler(handler);
        this.presenter.onStartup();
        Mockito.when((Object)this.itemView1.getSelectedBranch()).thenReturn((Object)"master");
        Branch theNewBranch = new Branch("theNewBranch", this.branchPath);
        ((GitRepository)this.r1).addBranch(theNewBranch);
        this.guvnorStructureContext.onNewBranch(new NewBranchEvent(this.r1, "theNewBranch"));
        ((GuvnorStructureContextChangeHandler)Mockito.verify((Object)handler)).onNewBranchAdded("r1", "theNewBranch", this.branchPath);
    }

    private RepositoryItemPresenter createItemPresenter(RepositoryItemView itemView, GuvnorStructureContext guvnorStructureContext, Repository repository, String branch) {
        RepositoryItemPresenter itemPresenter = new RepositoryItemPresenter(itemView, guvnorStructureContext, this.notification);
        itemPresenter.setRepository(repository, branch);
        return itemPresenter;
    }

    private Repository createRepository(String alias, String space) {
        GitRepository repository = new GitRepository(alias, new Space(space));
        repository.addBranch(new Branch("master", this.branchPath));
        return repository;
    }
}

