/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.client.editors.repository.list.RepositoriesView;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemPresenter;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.OnShutdown;
import org.uberfire.lifecycle.OnStartup;

@Dependent
@WorkbenchScreen(identifier="RepositoriesEditor")
public class RepositoriesPresenter
implements GuvnorStructureContextChangeHandler {
    private GuvnorStructureContext guvnorStructureContext;
    private Map<Repository, RepositoryItemPresenter> repositoryToWidgetMap = new HashMap<Repository, RepositoryItemPresenter>();
    private RepositoriesView view;
    private GuvnorStructureContextChangeHandler.HandlerRegistration changeHandlerRegistration;

    public RepositoriesPresenter() {
    }

    @Inject
    public RepositoriesPresenter(RepositoriesView view, GuvnorStructureContext guvnorStructureContext) {
        this.view = view;
        this.guvnorStructureContext = guvnorStructureContext;
        this.changeHandlerRegistration = guvnorStructureContext.addGuvnorStructureContextChangeHandler(this);
        view.setPresenter(this);
    }

    @OnStartup
    public void onStartup() {
        this.loadContent();
    }

    @OnShutdown
    public void shutdown() {
        this.guvnorStructureContext.removeHandler(this.changeHandlerRegistration);
    }

    private void loadContent() {
        this.repositoryToWidgetMap.clear();
        this.view.clear();
        this.guvnorStructureContext.getRepositories(new Callback<Collection<Repository>>(){

            public void callback(Collection<Repository> response) {
                for (Repository repo : response) {
                    RepositoriesPresenter.this.repositoryToWidgetMap.put(repo, RepositoriesPresenter.this.addRepositoryItem(repo, RepositoriesPresenter.this.guvnorStructureContext.getCurrentBranch(repo.getAlias())));
                }
            }
        });
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.RepositoryEditor();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view.asWidget();
    }

    @Override
    public void onNewRepositoryAdded(Repository repository) {
        this.addRepositoryItem(repository, ((Branch)repository.getDefaultBranch().get()).getName());
    }

    @Override
    public void onNewBranchAdded(String repositoryAlias, String branchName, Path branchPath) {
        RepositoryItemPresenter itemPresenter;
        Repository repository = this.getRepositoryByAlias(repositoryAlias);
        if (repository != null && repository instanceof GitRepository && (itemPresenter = this.repositoryToWidgetMap.remove(repository)) != null) {
            ((GitRepository)repository).addBranch(new Branch(branchName, branchPath));
            this.repositoryToWidgetMap.put(repository, itemPresenter);
            itemPresenter.refreshBranches();
        }
    }

    @Override
    public void onRepositoryDeleted(Repository repository) {
        RepositoryItemPresenter repositoryItem = this.repositoryToWidgetMap.remove(repository);
        this.view.removeIfExists(repositoryItem);
    }

    private RepositoryItemPresenter addRepositoryItem(Repository newRepository, String branch) {
        RepositoryItemPresenter repositoryItemPresenter = this.view.addRepository(newRepository, branch);
        this.repositoryToWidgetMap.put(newRepository, repositoryItemPresenter);
        return repositoryItemPresenter;
    }

    public void onSystemRepositoryChanged(@Observes SystemRepositoryChangedEvent event) {
        this.loadContent();
    }

    private Repository getRepositoryByAlias(String alias) {
        for (Repository repository : this.repositoryToWidgetMap.keySet()) {
            if (!repository.getAlias().equals(alias)) continue;
            return repository;
        }
        return null;
    }
}

