/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.security;

import java.util.Collection;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class OrganizationalUnitControllerTest {
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private User user;
    private OrganizationalUnitController organizationalUnitController;

    @Before
    public void setup() {
        this.organizationalUnitController = (OrganizationalUnitController)Mockito.spy((Object)new OrganizationalUnitController(this.authorizationManager, this.user));
    }

    @Test
    public void userCanReadOrganizationalUnitsTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).canReadOrgUnits();
        Assert.assertTrue((boolean)this.organizationalUnitController.canReadOrgUnits());
    }

    @Test
    public void userCanNotReadOrganizationalUnitsTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).canReadOrgUnits();
        Assert.assertFalse((boolean)this.organizationalUnitController.canReadOrgUnits());
    }

    @Test
    public void userCanReadOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).canReadOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canReadOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanNotReadOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).canReadOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canReadOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanReadOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canReadOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanNotReadOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.CONTRIBUTOR), (Collection)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canReadOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanDeleteOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).canDeleteOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanNotDeleteOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).canDeleteOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanDeleteOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.OWNER), (Collection)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanNotDeleteOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.OWNER), (Collection)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canDeleteOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanUpdateOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).canUpdateOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanNotUpdateOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).canUpdateOrgUnit((OrganizationalUnit)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanUpdateOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.ADMIN), (Collection)Matchers.any());
        Assert.assertTrue((boolean)this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void contributorCanNotUpdateOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).userIsAtLeast((ContributorType)Matchers.eq((Object)ContributorType.ADMIN), (Collection)Matchers.any());
        Assert.assertFalse((boolean)this.organizationalUnitController.canUpdateOrgUnit((OrganizationalUnit)Mockito.mock(OrganizationalUnit.class)));
    }

    @Test
    public void userCanCreateOrganizationalUnitTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)true).when((Object)this.organizationalUnitController)).canCreateOrgUnits();
        Assert.assertTrue((boolean)this.organizationalUnitController.canCreateOrgUnits());
    }

    @Test
    public void userCanNotCreateOrganizationalUnitsTest() {
        ((OrganizationalUnitController)Mockito.doReturn((Object)false).when((Object)this.organizationalUnitController)).canCreateOrgUnits();
        Assert.assertFalse((boolean)this.organizationalUnitController.canCreateOrgUnits());
    }
}

