/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextBranchChangeHandler;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerItem;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerView;
import org.guvnor.structure.client.editors.fileexplorer.PathSelectedEvent;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.OnShutdown;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="FileExplorer")
public class FileExplorerPresenter
implements GuvnorStructureContextChangeHandler,
GuvnorStructureContextBranchChangeHandler {
    private FileExplorerView view;
    @Inject
    private Caller<VFSService> vfsService;
    @Inject
    private Event<PathSelectedEvent> pathSelectedEvent;
    @Inject
    private PlaceManager placeManager;
    private GuvnorStructureContext guvnorStructureContext;
    private Map<String, Repository> repositories = new HashMap<String, Repository>();
    private GuvnorStructureContextChangeHandler.HandlerRegistration changeHandlerRegistration;
    private GuvnorStructureContextBranchChangeHandler.HandlerRegistration branchChangeHandlerRegistration;

    public FileExplorerPresenter() {
    }

    @Inject
    public FileExplorerPresenter(FileExplorerView view, GuvnorStructureContext guvnorStructureContext) {
        this.view = view;
        this.guvnorStructureContext = guvnorStructureContext;
        this.changeHandlerRegistration = this.guvnorStructureContext.addGuvnorStructureContextChangeHandler(this);
        this.branchChangeHandlerRegistration = this.guvnorStructureContext.addGuvnorStructureContextBranchChangeHandler(this);
        view.init(this);
    }

    private boolean isDirectory(Map response) {
        return response != null && response.containsKey("isDirectory") && (Boolean)response.get("isDirectory") != false;
    }

    @OnStartup
    public void reset() {
        this.view.reset();
        this.guvnorStructureContext.getRepositories(new Callback<Collection<Repository>>(){

            public void callback(Collection<Repository> response) {
                for (Repository root : response) {
                    if (FileExplorerPresenter.this.repositories.containsKey(root.getAlias())) {
                        FileExplorerPresenter.this.view.removeRepository(root);
                    }
                    FileExplorerPresenter.this.view.addNewRepository(root, FileExplorerPresenter.this.guvnorStructureContext.getCurrentBranch(root.getAlias()));
                    FileExplorerPresenter.this.repositories.put(root.getAlias(), root);
                }
            }
        });
    }

    @OnShutdown
    public void onShutdown() {
        this.guvnorStructureContext.removeHandler(this.changeHandlerRegistration);
        this.guvnorStructureContext.removeHandler(this.branchChangeHandlerRegistration);
    }

    public void loadDirectoryContent(final FileExplorerItem item, Path path) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<DirectoryStream<Path>>(){

            public void callback(DirectoryStream<Path> response) {
                for (final Path child : response) {
                    ((VFSService)FileExplorerPresenter.this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

                        public void callback(Map response) {
                            if (FileExplorerPresenter.this.isDirectory(response)) {
                                item.addDirectory(child);
                            } else {
                                item.addFile(child);
                            }
                        }
                    })).readAttributes(child);
                }
            }
        })).newDirectoryStream(path);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    private boolean isRegularFile(Map response) {
        return response != null && response.containsKey("isRegularFile") && (Boolean)response.get("isRegularFile") != false;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.FileExplorer();
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    public void redirect(final Path path) {
        this.pathSelectedEvent.fire((Object)new PathSelectedEvent(path));
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

            public void callback(Map response) {
                if (FileExplorerPresenter.this.isRegularFile(response)) {
                    FileExplorerPresenter.this.placeManager.goTo(path);
                }
            }
        })).readAttributes(path);
    }

    public void redirectRepositoryList() {
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("RepositoriesEditor"));
    }

    public void redirect(Repository repo) {
        this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", repo.getAlias()));
    }

    @Override
    public void onNewRepositoryAdded(Repository repository) {
        if (repository == null) {
            return;
        }
        if (this.repositories.containsKey(repository.getAlias())) {
            this.view.removeRepository(repository);
        }
        this.view.addNewRepository(repository, ((Branch)repository.getDefaultBranch().get()).getName());
        this.repositories.put(repository.getAlias(), repository);
    }

    @Override
    public void onRepositoryDeleted(Repository repository) {
        if (repository == null) {
            return;
        }
        if (this.repositories.containsKey(repository.getAlias())) {
            this.view.removeRepository(repository);
            this.repositories.remove(repository.getAlias());
        }
    }

    @Override
    public void onBranchChange(String alias, String branch) {
        if (alias == null) {
            return;
        }
        if (this.repositories.containsKey(alias)) {
            Repository repository = this.repositories.get(alias);
            this.view.removeRepository(repository);
            this.view.addNewRepository(repository, branch);
        }
    }

    @Override
    public void onNewBranchAdded(String repositoryAlias, String branchName, Path branchPath) {
    }

    public void onResourceAdded(@Observes ResourceAddedEvent event) {
        this.refreshView(event.getPath());
    }

    public void onResourceDeleted(@Observes ResourceDeletedEvent event) {
        this.refreshView(event.getPath());
    }

    public void onResourceCopied(@Observes ResourceCopiedEvent event) {
        this.refreshView(event.getDestinationPath());
    }

    public void onResourceRenamed(@Observes ResourceRenamedEvent event) {
        this.refreshView(event.getDestinationPath());
    }

    public void onBatchResourceChange(@Observes ResourceBatchChangesEvent event) {
        this.reset();
    }

    public void onSystemRepositoryChanged(@Observes SystemRepositoryChangedEvent event) {
        this.reset();
    }

    private void refreshView(Path path) {
        String pathUri = path.toURI();
        for (Repository repository : this.repositories.values()) {
            String repositoryUri;
            if (!repository.getDefaultBranch().isPresent() || !pathUri.startsWith(repositoryUri = ((Branch)repository.getDefaultBranch().get()).getPath().toURI())) continue;
            this.reset();
            break;
        }
    }
}

