/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.spaces.Space;

public class RepositoryServiceCallerMock
implements Caller<RepositoryService> {
    protected RepositoryServiceWrapper repositoryServiceWrapper;
    protected RemoteCallback remoteCallback;

    public RepositoryServiceCallerMock(RepositoryService repositoryService) {
        this.repositoryServiceWrapper = new RepositoryServiceWrapper(repositoryService);
    }

    public RepositoryService call() {
        return this.repositoryServiceWrapper;
    }

    public RepositoryService call(RemoteCallback<?> remoteCallback) {
        return this.call(remoteCallback, (ErrorCallback<?>)null);
    }

    public RepositoryService call(RemoteCallback<?> remoteCallback, ErrorCallback<?> errorCallback) {
        this.remoteCallback = remoteCallback;
        return this.repositoryServiceWrapper;
    }

    private class RepositoryServiceWrapper
    implements RepositoryService {
        RepositoryService repositoryService;

        public RepositoryServiceWrapper(RepositoryService repositoryService) {
            this.repositoryService = repositoryService;
        }

        public RepositoryInfo getRepositoryInfo(Space space, String alias) {
            RepositoryInfo result = this.repositoryService.getRepositoryInfo(space, alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex) {
            List result = this.repositoryService.getRepositoryHistory(space, alias, startIndex);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex, int endIndex) {
            List result = this.repositoryService.getRepositoryHistory(space, alias, startIndex, endIndex);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public List<VersionRecord> getRepositoryHistoryAll(Space space, String alias) {
            List result = this.repositoryService.getRepositoryHistoryAll(space, alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository getRepositoryFromSpace(Space currentSpace, String alias) {
            Repository result = this.repositoryService.getRepositoryFromSpace(currentSpace, alias);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository getRepository(Path root) {
            Repository result = this.repositoryService.getRepository(root);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository getRepository(Space space, Path root) {
            Repository result = this.repositoryService.getRepository(space, root);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getAllRepositories(Space space) {
            Collection result = this.repositoryService.getAllRepositories(space);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getAllRepositories(Space space, boolean includeDeleted) {
            Collection result = this.repositoryService.getAllRepositories(space, includeDeleted);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getAllDeletedRepositories(Space space) {
            Collection result = this.repositoryService.getAllDeletedRepositories(space);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getAllRepositoriesFromAllUserSpaces() {
            Collection result = this.repositoryService.getAllRepositoriesFromAllUserSpaces();
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Collection<Repository> getRepositories(Space space) {
            Collection result = this.repositoryService.getRepositories(space);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations configurations) throws RepositoryAlreadyExistsException {
            Repository result = this.repositoryService.createRepository(organizationalUnit, scheme, alias, configurations);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations configurations, Collection<Contributor> contributors) throws RepositoryAlreadyExistsException {
            Repository result = this.repositoryService.createRepository(organizationalUnit, scheme, alias, configurations, contributors);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return null;
        }

        public String normalizeRepositoryName(String name) {
            String result = this.repositoryService.normalizeRepositoryName(name);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public boolean validateRepositoryName(String name) {
            boolean result = this.repositoryService.validateRepositoryName(name);
            RepositoryServiceCallerMock.this.remoteCallback.callback((Object)result);
            return result;
        }

        public void addGroup(Repository repository, String group) {
            this.repositoryService.addGroup(repository, group);
        }

        public void removeGroup(Repository repository, String group) {
            this.repositoryService.removeGroup(repository, group);
        }

        public void updateContributors(Repository repository, List<Contributor> contributors) {
            this.repositoryService.updateContributors(repository, contributors);
        }

        public void removeRepository(Space space, String alias) {
            this.repositoryService.removeRepository(space, alias);
        }

        public void removeRepositories(Space space, Set<String> aliases) {
            this.repositoryService.removeRepositories(space, aliases);
        }
    }
}

