/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.guvnor.structure.client.security.RepositoryTreeProvider;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositorySearchService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryTreeProviderTest {
    @Mock
    RepositorySearchService searchService;
    @Mock
    PermissionTree permissionTree;
    @Mock
    Repository repo1;
    @Mock
    Repository repo2;
    PermissionManager permissionManager;
    RepositoryTreeProvider treeProvider;
    PermissionNode rootNode;

    @Before
    public void setup() {
        this.permissionManager = new DefaultPermissionManager();
        this.treeProvider = new RepositoryTreeProvider(this.permissionManager, (Caller)new CallerMock((Object)this.searchService));
        this.rootNode = this.treeProvider.buildRootNode();
        this.rootNode.setPermissionTree(this.permissionTree);
        Mockito.when((Object)this.repo1.getIdentifier()).thenReturn((Object)"r1");
        Mockito.when((Object)this.repo2.getIdentifier()).thenReturn((Object)"r2");
        Mockito.when((Object)this.repo1.getAlias()).thenReturn((Object)"r1");
        Mockito.when((Object)this.repo2.getAlias()).thenReturn((Object)"r2");
        Mockito.when((Object)this.repo1.getResourceType()).thenReturn((Object)Repository.RESOURCE_TYPE);
        Mockito.when((Object)this.repo2.getResourceType()).thenReturn((Object)Repository.RESOURCE_TYPE);
        Mockito.when((Object)this.permissionTree.getChildrenResourceIds((PermissionNode)Mockito.any())).thenReturn(null);
        Mockito.when((Object)this.searchService.searchByAlias(Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean())).thenReturn(Arrays.asList(this.repo1, this.repo2));
    }

    @Test
    public void testRootNode() {
        Assert.assertEquals((long)this.rootNode.getPermissionList().size(), (long)5L);
        this.checkDependencies(this.rootNode, 3);
    }

    @Test
    public void testChildrenNodes() {
        this.rootNode.expand(children -> {
            ((RepositorySearchService)Mockito.verify((Object)this.searchService)).searchByAlias((String)Mockito.any(), Mockito.anyInt(), Mockito.anyBoolean());
            for (PermissionNode child : children) {
                List permissionList = child.getPermissionList();
                Assert.assertEquals((long)permissionList.size(), (long)4L);
                this.checkDependencies(child, 3);
                List permissionNames = permissionList.stream().map(Permission::getName).collect(Collectors.toList());
                Assert.assertTrue((boolean)permissionNames.contains("repository.read." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("repository.update." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("repository.delete." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("repository.build." + child.getNodeName()));
                Assert.assertEquals((long)child.getPermissionList().size(), (long)4L);
                this.checkDependencies(child, 3);
            }
        });
    }

    protected void checkDependencies(PermissionNode permissionNode, int numberOfDependencies) {
        for (Permission permission : permissionNode.getPermissionList()) {
            List dependencies = permissionNode.getDependencies(permission);
            if (permission.getName().startsWith("repository.read")) {
                Assert.assertEquals((long)dependencies.size(), (long)numberOfDependencies);
                continue;
            }
            Assert.assertNull((Object)dependencies);
        }
    }
}

