/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerItem;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerPresenter;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerView;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.tree.FSTreeItem;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

public class FileExplorerViewImpl
extends Composite
implements FileExplorerView {
    private static final String REPOSITORY_ID = "repositories";
    private final Map<Repository, FSTreeItem> repositoryToTreeItemMap = new HashMap<Repository, FSTreeItem>();
    private final FlowPanel panel = (FlowPanel)GWT.create(FlowPanel.class);
    private final Tree<FSTreeItem> tree;
    FSTreeItem rootTreeItem = null;
    private CommonConstants constants = CommonConstants.INSTANCE;
    private FileExplorerPresenter presenter = null;

    public FileExplorerViewImpl() {
        this.tree = (Tree)GWT.create(Tree.class);
    }

    FileExplorerViewImpl(Tree<FSTreeItem> tree) {
        this.tree = tree;
    }

    @Override
    public void init(final FileExplorerPresenter presenter) {
        this.presenter = presenter;
        FSTreeItem item = new FSTreeItem(FSTreeItem.FSType.FOLDER, this.constants.Repositories());
        this.rootTreeItem = (FSTreeItem)this.tree.addItem((TreeItem)item);
        this.rootTreeItem.setState(TreeItem.State.OPEN);
        this.panel.getElement().getStyle().setFloat(Style.Float.LEFT);
        this.panel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.panel.add(this.tree);
        this.initWidget((Widget)this.panel);
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<FSTreeItem>(){

            public void onOpen(OpenEvent<FSTreeItem> event) {
                if (FileExplorerViewImpl.this.needsLoading((FSTreeItem)event.getTarget())) {
                    presenter.loadDirectoryContent(new FileExplorerItem((FSTreeItem)event.getTarget()), (Path)((FSTreeItem)event.getTarget()).getUserObject());
                }
            }
        });
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<FSTreeItem>(){

            public void onSelection(SelectionEvent<FSTreeItem> event) {
                Object userObject = ((FSTreeItem)event.getSelectedItem()).getUserObject();
                if (userObject != null && userObject instanceof Path) {
                    Path path = (Path)userObject;
                    presenter.redirect(path);
                } else if (userObject != null && userObject instanceof Repository) {
                    Repository root = (Repository)userObject;
                    presenter.redirect(root);
                } else if (((FSTreeItem)event.getSelectedItem()).getUserObject() instanceof String && ((FSTreeItem)event.getSelectedItem()).getUserObject().equals(FileExplorerViewImpl.REPOSITORY_ID)) {
                    presenter.redirectRepositoryList();
                }
            }
        });
    }

    @Override
    public void reset() {
        this.rootTreeItem.setUserObject((Object)REPOSITORY_ID);
        this.rootTreeItem.addItem(FSTreeItem.FSType.LOADING, this.constants.Loading());
        this.rootTreeItem.removeItems();
        this.repositoryToTreeItemMap.clear();
    }

    @Override
    public void removeRepository(Repository repo) {
        if (!this.repositoryToTreeItemMap.containsKey(repo)) {
            return;
        }
        FSTreeItem repositoryRootItem = this.repositoryToTreeItemMap.remove(repo);
        repositoryRootItem.remove();
    }

    @Override
    public void addNewRepository(Repository repository, String branchName) {
        FSTreeItem repositoryRootItem = this.rootTreeItem.addItem(FSTreeItem.FSType.FOLDER, repository.getAlias());
        repositoryRootItem.setUserObject((Object)repository);
        repositoryRootItem.setState(TreeItem.State.OPEN, false, false);
        this.repositoryToTreeItemMap.put(repository, repositoryRootItem);
        repository.getBranch(branchName).ifPresent(branch -> this.presenter.loadDirectoryContent(new FileExplorerItem(repositoryRootItem), branch.getPath()));
    }

    boolean needsLoading(FSTreeItem item) {
        return item.getUserObject() instanceof Path && item.getFSType() == FSTreeItem.FSType.FOLDER && item.getChildCount() == 1 && this.constants.Loading().equals(((FSTreeItem)item.getChild(0)).getText());
    }
}

