/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.context;

import java.util.HashMap;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextBranchChangeHandler;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GuvnorStructureContextHandlersTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private WorkspaceProjectContext projContext;
    private GuvnorStructureContext context;

    @Before
    public void setUp() throws Exception {
        this.context = new GuvnorStructureContext((Caller)new CallerMock((Object)this.repositoryService), this.projContext);
    }

    @Test
    public void testHandler() throws Exception {
        GuvnorStructureContextChangeHandler handler1 = (GuvnorStructureContextChangeHandler)Mockito.mock(GuvnorStructureContextChangeHandler.class);
        GuvnorStructureContextChangeHandler handler2 = (GuvnorStructureContextChangeHandler)Mockito.mock(GuvnorStructureContextChangeHandler.class);
        GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration1 = this.context.addGuvnorStructureContextChangeHandler(handler1);
        GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration2 = this.context.addGuvnorStructureContextChangeHandler(handler2);
        Assert.assertNotNull((Object)handlerRegistration1);
        Assert.assertNotNull((Object)handlerRegistration2);
        this.context.removeHandler(handlerRegistration2);
        GitRepository newRepository = new GitRepository();
        this.context.onRepositoryRemoved(new RepositoryRemovedEvent((Repository)newRepository));
        ((GuvnorStructureContextChangeHandler)Mockito.verify((Object)handler1)).onRepositoryDeleted((Repository)newRepository);
        ((GuvnorStructureContextChangeHandler)Mockito.verify((Object)handler2, (VerificationMode)Mockito.never())).onRepositoryDeleted((Repository)newRepository);
    }

    @Test
    public void testNewRepository() throws Exception {
        GuvnorStructureContextChangeHandler handler = (GuvnorStructureContextChangeHandler)Mockito.mock(GuvnorStructureContextChangeHandler.class);
        this.context.addGuvnorStructureContextChangeHandler(handler);
        GitRepository newRepository = new GitRepository();
        HashMap<String, Branch> branches = new HashMap<String, Branch>();
        branches.put("master", new Branch("master", (Path)Mockito.mock(Path.class)));
        newRepository.setBranches(branches);
        this.context.onNewRepository(new NewRepositoryEvent((Repository)newRepository));
        ((GuvnorStructureContextChangeHandler)Mockito.verify((Object)handler)).onNewRepositoryAdded((Repository)newRepository);
    }

    @Test
    public void testBranchChange() throws Exception {
        GuvnorStructureContextBranchChangeHandler handler = (GuvnorStructureContextBranchChangeHandler)Mockito.mock(GuvnorStructureContextBranchChangeHandler.class);
        this.context.addGuvnorStructureContextBranchChangeHandler(handler);
        this.context.changeBranch("your-repo", "hello");
        ((GuvnorStructureContextBranchChangeHandler)Mockito.verify((Object)handler)).onBranchChange("your-repo", "hello");
    }

    @Test
    public void testRemoveBranchChangeHandler() throws Exception {
        GuvnorStructureContextBranchChangeHandler handler1 = (GuvnorStructureContextBranchChangeHandler)Mockito.mock(GuvnorStructureContextBranchChangeHandler.class);
        GuvnorStructureContextBranchChangeHandler handler2 = (GuvnorStructureContextBranchChangeHandler)Mockito.mock(GuvnorStructureContextBranchChangeHandler.class);
        GuvnorStructureContextBranchChangeHandler.HandlerRegistration handlerRegistration1 = this.context.addGuvnorStructureContextBranchChangeHandler(handler1);
        GuvnorStructureContextBranchChangeHandler.HandlerRegistration handlerRegistration2 = this.context.addGuvnorStructureContextBranchChangeHandler(handler2);
        Assert.assertNotNull((Object)handlerRegistration1);
        Assert.assertNotNull((Object)handlerRegistration2);
        this.context.removeHandler(handlerRegistration1);
        this.context.changeBranch("my-repo", "master");
        ((GuvnorStructureContextBranchChangeHandler)Mockito.verify((Object)handler1, (VerificationMode)Mockito.never())).onBranchChange("my-repo", "master");
        ((GuvnorStructureContextBranchChangeHandler)Mockito.verify((Object)handler2)).onBranchChange("my-repo", "master");
    }
}

