/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.organizationalunit;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.guvnor.structure.client.security.OrganizationalUnitTreeProvider;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitSearchService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTree;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class OrganizationalUnitTreeProviderTest {
    @Mock
    OrganizationalUnitSearchService searchService;
    @Mock
    PermissionTree permissionTree;
    @Mock
    OrganizationalUnit orgUnit1;
    @Mock
    OrganizationalUnit orgUnit2;
    PermissionManager permissionManager;
    OrganizationalUnitTreeProvider treeProvider;
    PermissionNode rootNode;

    @Before
    public void setup() {
        this.permissionManager = new DefaultPermissionManager();
        this.treeProvider = new OrganizationalUnitTreeProvider(this.permissionManager, (Caller)new CallerMock((Object)this.searchService));
        this.rootNode = this.treeProvider.buildRootNode();
        this.rootNode.setPermissionTree(this.permissionTree);
        Mockito.when((Object)this.orgUnit1.getIdentifier()).thenReturn((Object)"ou1");
        Mockito.when((Object)this.orgUnit2.getIdentifier()).thenReturn((Object)"ou2");
        Mockito.when((Object)this.orgUnit1.getName()).thenReturn((Object)"ou1");
        Mockito.when((Object)this.orgUnit2.getName()).thenReturn((Object)"ou2");
        Mockito.when((Object)this.orgUnit1.getResourceType()).thenReturn((Object)OrganizationalUnit.RESOURCE_TYPE);
        Mockito.when((Object)this.orgUnit2.getResourceType()).thenReturn((Object)OrganizationalUnit.RESOURCE_TYPE);
        Mockito.when((Object)this.permissionTree.getChildrenResourceIds((PermissionNode)Mockito.any())).thenReturn(null);
        Mockito.when((Object)this.searchService.searchByName(Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean())).thenReturn(Arrays.asList(this.orgUnit1, this.orgUnit2));
    }

    @Test
    public void testRootNode() {
        Assert.assertEquals((long)this.rootNode.getPermissionList().size(), (long)4L);
        this.checkDependencies(this.rootNode, 2);
    }

    @Test
    public void testChildrenNodes() {
        this.rootNode.expand(children -> {
            ((OrganizationalUnitSearchService)Mockito.verify((Object)this.searchService)).searchByName((String)Mockito.any(), Mockito.anyInt(), Mockito.anyBoolean());
            for (PermissionNode child : children) {
                List permissionList = child.getPermissionList();
                Assert.assertEquals((long)permissionList.size(), (long)3L);
                this.checkDependencies(child, 2);
                List permissionNames = permissionList.stream().map(Permission::getName).collect(Collectors.toList());
                Assert.assertTrue((boolean)permissionNames.contains("orgunit.read." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("orgunit.update." + child.getNodeName()));
                Assert.assertTrue((boolean)permissionNames.contains("orgunit.delete." + child.getNodeName()));
            }
        });
    }

    protected void checkDependencies(PermissionNode permissionNode, int numberOfDependencies) {
        for (Permission permission : permissionNode.getPermissionList()) {
            List dependencies = permissionNode.getDependencies(permission);
            if (permission.getName().startsWith("orgunit.read")) {
                Assert.assertEquals((long)dependencies.size(), (long)numberOfDependencies);
                continue;
            }
            Assert.assertNull((Object)dependencies);
        }
    }
}

