/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.security;

import java.util.Collection;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class OrganizationalUnitController {
    public static final String ORG_UNIT_TYPE = "orgunit";
    public static final String ORG_UNIT_CREATE = "create";
    public static final String ORG_UNIT_READ = "read";
    public static final String ORG_UNIT_UPDATE = "update";
    public static final String ORG_UNIT_DELETE = "delete";
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public OrganizationalUnitController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public boolean canCreateOrgUnits() {
        return this.authorizationManager.authorize((ResourceType)OrganizationalUnit.RESOURCE_TYPE, (ResourceAction)OrganizationalUnitAction.CREATE, this.user);
    }

    public boolean canReadOrgUnits() {
        return this.authorizationManager.authorize((ResourceType)OrganizationalUnit.RESOURCE_TYPE, OrganizationalUnitAction.READ, this.user);
    }

    public boolean canReadOrgUnit(OrganizationalUnit organizationalUnit) {
        boolean securityPermission = this.authorizationManager.authorize((Resource)organizationalUnit, OrganizationalUnitAction.READ, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.CONTRIBUTOR, organizationalUnit.getContributors());
    }

    public boolean canUpdateOrgUnit(OrganizationalUnit organizationalUnit) {
        boolean securityPermission = this.authorizationManager.authorize((Resource)organizationalUnit, (ResourceAction)OrganizationalUnitAction.UPDATE, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.ADMIN, organizationalUnit.getContributors());
    }

    public boolean canDeleteOrgUnit(OrganizationalUnit organizationalUnit) {
        boolean securityPermission = this.authorizationManager.authorize((Resource)organizationalUnit, (ResourceAction)OrganizationalUnitAction.DELETE, this.user);
        return securityPermission || this.userIsAtLeast(ContributorType.OWNER, organizationalUnit.getContributors());
    }

    boolean userIsAtLeast(ContributorType type, Collection<Contributor> contributors) {
        return contributors.stream().anyMatch(c -> c.getUsername().equals(this.user.getIdentifier()) && ContributorType.PRIORITY_ORDER.indexOf(c.getType()) <= ContributorType.PRIORITY_ORDER.indexOf(type));
    }

    Optional<Contributor> getUserContributor(Collection<Contributor> contributors) {
        return contributors.stream().filter(c -> c.getUsername().equals(this.user.getIdentifier())).findFirst();
    }
}

