/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryView;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.RemoveOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.util.URIUtil;

@Dependent
public class CloneRepositoryPresenter
implements CloneRepositoryView.Presenter {
    private RepositoryPreferences repositoryPreferences;
    private CloneRepositoryView view;
    private Caller<RepositoryService> repositoryService;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private PlaceManager placeManager;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();

    @Inject
    public CloneRepositoryPresenter(RepositoryPreferences repositoryPreferences, CloneRepositoryView view, Caller<RepositoryService> repositoryService, Caller<OrganizationalUnitService> organizationalUnitService, PlaceManager placeManager) {
        this.repositoryPreferences = repositoryPreferences;
        this.view = view;
        this.repositoryService = repositoryService;
        this.organizationalUnitService = organizationalUnitService;
        this.placeManager = placeManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this, this.isOuMandatory());
        this.populateOrganizationalUnits();
    }

    @Override
    public void handleCancelClick() {
        this.view.hide();
    }

    @Override
    public void handleCloneClick() {
        boolean urlConditionsMet = this.setUrl();
        boolean ouConditionsMet = this.setOrganizationalUnitGroupType();
        boolean nameConditionsMet = this.setNameGroupType();
        if (urlConditionsMet && ouConditionsMet && nameConditionsMet) {
            ((RepositoryService)this.repositoryService.call(this.getNormalizeRepositoryNameCallback())).normalizeRepositoryName(this.view.getName());
        }
    }

    public void onCreateOrganizationalUnit(@Observes AfterCreateOrganizationalUnitEvent event) {
        OrganizationalUnit organizationalUnit = event.getOrganizationalUnit();
        if (organizationalUnit == null) {
            return;
        }
        this.view.addOrganizationalUnit(organizationalUnit);
        this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
    }

    public void onDeleteOrganizationalUnit(@Observes RemoveOrganizationalUnitEvent event) {
        OrganizationalUnit organizationalUnit = event.getOrganizationalUnit();
        if (organizationalUnit == null) {
            return;
        }
        this.view.deleteOrganizationalUnit(organizationalUnit);
        this.availableOrganizationalUnits.remove(organizationalUnit.getName());
    }

    private RemoteCallback<String> getNormalizeRepositoryNameCallback() {
        return new RemoteCallback<String>(){

            public void callback(String normalizedName) {
                if (!CloneRepositoryPresenter.this.view.getName().equals(normalizedName)) {
                    if (!CloneRepositoryPresenter.this.view.showAgreeNormalizeNameWindow(normalizedName)) {
                        return;
                    }
                    CloneRepositoryPresenter.this.view.setName(normalizedName);
                }
                CloneRepositoryPresenter.this.lockScreen();
                String scheme = "git";
                String alias = CloneRepositoryPresenter.this.view.getName().trim();
                ((RepositoryService)CloneRepositoryPresenter.this.repositoryService.call(CloneRepositoryPresenter.this.getCreateRepositoryCallback(), CloneRepositoryPresenter.this.getErrorCallback())).createRepository((OrganizationalUnit)CloneRepositoryPresenter.this.availableOrganizationalUnits.get(CloneRepositoryPresenter.this.view.getSelectedOrganizationalUnit()), "git", alias, CloneRepositoryPresenter.this.getRepositoryConfiguration(CloneRepositoryPresenter.this.view.getSelectedOrganizationalUnit()));
            }
        };
    }

    private RepositoryEnvironmentConfigurations getRepositoryConfiguration(String selectedOrganizationalUnit) {
        RepositoryEnvironmentConfigurations configuration = new RepositoryEnvironmentConfigurations();
        configuration.setUserName(this.view.getUsername().trim());
        configuration.setPassword(this.view.getPassword().trim());
        configuration.setOrigin(this.view.getGitUrl());
        configuration.setSpace(selectedOrganizationalUnit);
        return configuration;
    }

    private RemoteCallback<Repository> getCreateRepositoryCallback() {
        return new RemoteCallback<Repository>(){

            public void callback(Repository o) {
                CloneRepositoryPresenter.this.view.alertRepositoryCloned();
                CloneRepositoryPresenter.this.unlockScreen();
                CloneRepositoryPresenter.this.view.hide();
                CloneRepositoryPresenter.this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", o.getAlias()));
            }
        };
    }

    private ErrorCallback<Message> getErrorCallback() {
        return new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (RepositoryAlreadyExistsException ex) {
                    CloneRepositoryPresenter.this.view.errorRepositoryAlreadyExist();
                }
                catch (Throwable ex) {
                    CloneRepositoryPresenter.this.view.errorCloneRepositoryFail(ex);
                }
                CloneRepositoryPresenter.this.unlockScreen();
                return true;
            }
        };
    }

    private boolean setNameGroupType() {
        if (this.view.isNameEmpty()) {
            this.view.setNameGroupType(ValidationState.ERROR);
            this.view.showNameHelpMandatoryMessage();
            return false;
        }
        this.view.setNameGroupType(ValidationState.NONE);
        return true;
    }

    private boolean setOrganizationalUnitGroupType() {
        if (this.isOuMandatory() && !this.availableOrganizationalUnits.containsKey(this.view.getSelectedOrganizationalUnit())) {
            this.view.setOrganizationalUnitGroupType(ValidationState.ERROR);
            this.view.showOrganizationalUnitHelpMandatoryMessage();
            return false;
        }
        this.view.setOrganizationalUnitGroupType(ValidationState.NONE);
        return true;
    }

    private boolean setUrl() {
        if (this.view.isGitUrlEmpty()) {
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpMandatoryMessage();
            return false;
        }
        if (!URIUtil.isValid((String)this.view.getGitUrl())) {
            this.view.setUrlGroupType(ValidationState.ERROR);
            this.view.showUrlHelpInvalidFormatMessage();
            return false;
        }
        this.view.setUrlGroupType(ValidationState.NONE);
        return true;
    }

    public void showForm() {
        this.view.reset();
        this.view.show();
    }

    private void populateOrganizationalUnits() {
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                CloneRepositoryPresenter.this.view.addOrganizationalUnitSelectEntry();
                if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
                    for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                        CloneRepositoryPresenter.this.view.addOrganizationalUnit(organizationalUnit);
                        CloneRepositoryPresenter.this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                    }
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                CloneRepositoryPresenter.this.view.errorLoadOrganizationalUnitsFail(throwable);
                return false;
            }
        })).getOrganizationalUnits();
    }

    private void lockScreen() {
        this.view.showBusyPopupMessage();
        this.view.setPopupCloseVisible(false);
        this.view.setCloneEnabled(false);
        this.view.setCancelEnabled(false);
        this.view.setPasswordEnabled(false);
        this.view.setUsernameEnabled(false);
        this.view.setGitUrlEnabled(false);
        this.view.setOrganizationalUnitEnabled(false);
        this.view.setNameEnabled(false);
    }

    private void unlockScreen() {
        this.view.closeBusyPopup();
        this.view.setPopupCloseVisible(true);
        this.view.setCloneEnabled(true);
        this.view.setCancelEnabled(true);
        this.view.setPasswordEnabled(true);
        this.view.setUsernameEnabled(true);
        this.view.setGitUrlEnabled(true);
        this.view.setOrganizationalUnitEnabled(true);
        this.view.setNameEnabled(true);
    }

    private boolean isOuMandatory() {
        return this.repositoryPreferences == null || this.repositoryPreferences.isOUMandatory();
    }
}

