/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.navigator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class CommitNavigatorEntry
extends Composite {
    private static final DateTimeFormat fmt = DateTimeFormat.getFormat((String)"yyyy-MM-dd h:mm a");
    private static CommitNavigatorEntryViewBinder uiBinder = (CommitNavigatorEntryViewBinder)GWT.create(CommitNavigatorEntryViewBinder.class);
    @UiField
    Label message;
    @UiField
    InlineLabel author;
    @UiField
    InlineLabel date;
    @UiField
    SimplePanel revertButtonContainer;

    public CommitNavigatorEntry(boolean readOnly, VersionRecord versionRecord, ParameterizedCommand<VersionRecord> onRevertCommand) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.initWidget(readOnly, versionRecord, onRevertCommand);
    }

    private void initWidget(final boolean readOnly, final VersionRecord versionRecord, final ParameterizedCommand<VersionRecord> onRevertCommand) {
        this.message.setText(versionRecord.comment());
        this.author.setText(versionRecord.author() + " - ");
        this.date.setText(fmt.format(versionRecord.date()));
        if (onRevertCommand != null) {
            this.revertButtonContainer.setWidget((Widget)new Button(CoreConstants.INSTANCE.RevertToThis()){
                {
                    super(text);
                    this.setEnabled(!readOnly);
                    this.setBlock(true);
                    this.setType(ButtonType.DANGER);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            YesNoCancelPopup yesNoCancelPopup = YesNoCancelPopup.newYesNoCancelPopup((String)CommonConstants.INSTANCE.Warning(), (String)CoreConstants.INSTANCE.ConfirmStateRevert(), (Command)new Command(){

                                public void execute() {
                                    onRevertCommand.execute((Object)versionRecord);
                                }
                            }, (Command)new Command(){

                                public void execute() {
                                }
                            }, null);
                            yesNoCancelPopup.setClosable(false);
                            yesNoCancelPopup.show();
                        }
                    });
                }
            });
        }
    }

    static interface CommitNavigatorEntryViewBinder
    extends UiBinder<Widget, CommitNavigatorEntry> {
    }
}

