/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.git;

import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.guvnor.structure.client.repositories.git.FileSystemHookNotifier;
import org.guvnor.structure.repositories.impl.git.event.NotificationType;
import org.guvnor.structure.repositories.impl.git.event.PostCommitNotificationEvent;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class FileSystemHookNotifierTest {
    private static final String MESSAGE = "notification message";
    @Mock
    private Event<NotificationEvent> notificationEvent;
    private FileSystemHookNotifier notifier;

    @Before
    public void init() {
        this.notifier = new FileSystemHookNotifier(this.notificationEvent);
    }

    @Test
    public void testNotificationSuccess() {
        this.testNotification(new PostCommitNotificationEvent(NotificationType.SUCCESS, MESSAGE), MESSAGE, NotificationEvent.NotificationType.SUCCESS);
    }

    @Test
    public void testNotificationWarning() {
        this.testNotification(new PostCommitNotificationEvent(NotificationType.WARNING, MESSAGE), MESSAGE, NotificationEvent.NotificationType.WARNING);
    }

    @Test
    public void testNotificationError() {
        this.testNotification(new PostCommitNotificationEvent(NotificationType.ERROR, MESSAGE), MESSAGE, NotificationEvent.NotificationType.ERROR);
    }

    private void testNotification(PostCommitNotificationEvent event, String expectedMessage, NotificationEvent.NotificationType expectedType) {
        this.notifier.notify(event);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((Event)Mockito.verify(this.notificationEvent)).fire((Object)((NotificationEvent)eventCaptor.capture()));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)((NotificationEvent)eventCaptor.getValue())).isNotNull()).hasFieldOrPropertyWithValue("notification", (Object)expectedMessage)).hasFieldOrPropertyWithValue("type", (Object)expectedType);
    }
}

