/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.structure.client.editors.TestUtil;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextBranchChangeHandler;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerPresenter;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerView;
import org.guvnor.structure.repositories.Repository;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileExplorerPresenterTest {
    @Mock
    private FileExplorerView view;
    private GuvnorStructureContext context;
    private FileExplorerPresenter presenter;
    private Collection<Repository> repositories;
    private Repository myRepo;
    private String myRepoBranch = "main";
    private Repository yourRepo;
    private String yourRepoBranch = "main";
    private GuvnorStructureContextChangeHandler.HandlerRegistration changeHandlerRegistration;
    private GuvnorStructureContextBranchChangeHandler.HandlerRegistration branchChangeHandlerRegistration;

    @Before
    public void setUp() throws Exception {
        this.repositories = new ArrayList<Repository>();
        this.myRepo = TestUtil.makeRepository("my-repo", "main", "dev");
        this.repositories.add(this.myRepo);
        this.yourRepo = TestUtil.makeRepository("your-repo", "main", "release");
        this.repositories.add(this.yourRepo);
        this.context = (GuvnorStructureContext)Mockito.spy((Object)new GuvnorStructureContext(){

            public void getRepositories(Callback<Collection<Repository>> callback) {
                callback.callback((Object)FileExplorerPresenterTest.this.repositories);
            }

            public GuvnorStructureContextChangeHandler.HandlerRegistration addGuvnorStructureContextChangeHandler(GuvnorStructureContextChangeHandler handler) {
                return FileExplorerPresenterTest.this.changeHandlerRegistration;
            }

            public GuvnorStructureContextBranchChangeHandler.HandlerRegistration addGuvnorStructureContextBranchChangeHandler(GuvnorStructureContextBranchChangeHandler handler) {
                return FileExplorerPresenterTest.this.branchChangeHandlerRegistration;
            }

            public String getCurrentBranch(String alias) {
                if (alias.equals("my-repo")) {
                    return FileExplorerPresenterTest.this.myRepoBranch;
                }
                if (alias.equals("your-repo")) {
                    return FileExplorerPresenterTest.this.yourRepoBranch;
                }
                return null;
            }
        });
        this.presenter = new FileExplorerPresenter(this.view, this.context);
    }

    @Test
    public void testSetPresenter() throws Exception {
        ((FileExplorerView)Mockito.verify((Object)this.view)).init(this.presenter);
    }

    @Test
    public void testAddHandlers() throws Exception {
        ((GuvnorStructureContext)Mockito.verify((Object)this.context)).addGuvnorStructureContextChangeHandler((GuvnorStructureContextChangeHandler)this.presenter);
        ((GuvnorStructureContext)Mockito.verify((Object)this.context)).addGuvnorStructureContextBranchChangeHandler((GuvnorStructureContextBranchChangeHandler)this.presenter);
    }

    @Test
    public void testRemoveHandlers() throws Exception {
        ((GuvnorStructureContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).removeHandler((GuvnorStructureContextBranchChangeHandler.HandlerRegistration)Mockito.any(GuvnorStructureContextBranchChangeHandler.HandlerRegistration.class));
        ((GuvnorStructureContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).removeHandler((GuvnorStructureContextChangeHandler.HandlerRegistration)Mockito.any(GuvnorStructureContextChangeHandler.HandlerRegistration.class));
        this.presenter.onShutdown();
        ((GuvnorStructureContext)Mockito.verify((Object)this.context)).removeHandler(this.branchChangeHandlerRegistration);
        ((GuvnorStructureContext)Mockito.verify((Object)this.context)).removeHandler(this.changeHandlerRegistration);
    }

    @Test
    public void testOnStartUp() throws Exception {
        this.myRepoBranch = "dev";
        this.presenter.reset();
        ((FileExplorerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addNewRepository((Repository)Mockito.any(Repository.class), Mockito.anyString());
        ((FileExplorerView)Mockito.verify((Object)this.view)).addNewRepository(this.myRepo, "dev");
        ((FileExplorerView)Mockito.verify((Object)this.view)).addNewRepository(this.yourRepo, "main");
    }
}

