/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.common.client.tables.DataGridFilter;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;

public class FilterPagedTable<T>
extends Composite {
    @UiField
    public TabPanel tabPanel;
    private HashMap<String, DataGridFilter> dataGridFilterHashMap = new HashMap();
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    public Command refreshGridCommand;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public FilterPagedTable() {
    }

    public FilterPagedTable(MultiGridPreferencesStore gridsPreferences) {
        this.multiGridPreferencesStore = gridsPreferences;
    }

    public void removeTab(String gridKey) {
        int index = this.getGridIndex(gridKey);
        if (index != -1) {
            this.dataGridFilterHashMap.remove(gridKey);
            this.tabPanel.remove(index);
            this.multiGridPreferencesStore.removeTab(gridKey);
            this.multiGridPreferencesStore.setSelectedGrid("");
            if (this.tabPanel.getWidgetCount() > 1) {
                this.tabPanel.selectTab(index - 1);
            }
            ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
        }
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        int i = this.dataGridFilterHashMap.size();
        while (this.dataGridFilterHashMap.get(baseName + i) != null) {
            ++i;
        }
        return baseName + i;
    }

    public void createNewTab(PagedTable<T> pagedTable, String key, Button button, Command filterCommand) {
        this.multiGridPreferencesStore.setSelectedGrid(key);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
        if (this.tabPanel.getWidgetCount() > 0) {
            this.tabPanel.remove(this.tabPanel.getWidgetCount() - 1);
        }
        this.addTab(pagedTable, key, filterCommand);
        this.addAddTableButton(button);
        this.tabPanel.selectTab(this.dataGridFilterHashMap.size() - 1);
    }

    public void addTab(PagedTable<T> grid, final String key, Command filterCommand) {
        this.dataGridFilterHashMap.put(key, new DataGridFilter(key, filterCommand));
        String gridHeader = this.multiGridPreferencesStore.getGridSettingParam(key, NewTabFilterPopup.FILTER_TAB_NAME_PARAM);
        String gridTitle = this.multiGridPreferencesStore.getGridSettingParam(key, NewTabFilterPopup.FILTER_TAB_DESC_PARAM);
        grid.addTableTitle(gridTitle);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setStyleName("tabHeader");
        panel.setTitle(gridHeader);
        Label text = new Label();
        text.setText(gridHeader);
        text.setStyleDependentName("text", true);
        panel.add((Widget)text);
        panel.setCellHorizontalAlignment((Widget)text, HasHorizontalAlignment.ALIGN_LEFT);
        if (!"base".equals(key)) {
            Button close = new Button();
            close.setIcon(IconType.REMOVE);
            close.setSize(ButtonSize.MINI);
            close.setTitle("close " + gridHeader);
            text.setStyleDependentName("close", true);
            close.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    FilterPagedTable.this.removeTab(key);
                }
            });
            panel.add((Widget)close);
            panel.setCellHorizontalAlignment((Widget)close, HasHorizontalAlignment.ALIGN_RIGHT);
        }
        panel.setWidth("100px");
        panel.setHeight("25px");
        VerticalPanel tableWithTitle = new VerticalPanel();
        tableWithTitle.add(grid);
        this.tabPanel.add((Widget)tableWithTitle, (Widget)panel);
        this.tabPanel.selectTab(this.dataGridFilterHashMap.size() - 1);
    }

    public void addAddTableButton(Button addTableButton) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setStyleName("tabHeader");
        panel.add((Widget)addTableButton);
        panel.setWidth("30px");
        panel.setHeight("25px");
        addTableButton.setSize(ButtonSize.MINI);
        this.tabPanel.add((Widget)new HTML("Default"), (Widget)panel);
    }

    public Widget makeWidget() {
        Widget w = (Widget)uiBinder.createAndBindUi((Object)this);
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                Integer selectedPosition = (Integer)event.getSelectedItem();
                ArrayList tabsId = FilterPagedTable.this.multiGridPreferencesStore.getGridsId();
                if (selectedPosition < tabsId.size()) {
                    String key = (String)tabsId.get(selectedPosition);
                    FilterPagedTable.this.multiGridPreferencesStore.setSelectedGrid(key);
                    ((UserPreferencesService)FilterPagedTable.this.preferencesService.call()).saveUserPreferences((UserPreference)FilterPagedTable.this.multiGridPreferencesStore);
                    ((DataGridFilter)FilterPagedTable.this.dataGridFilterHashMap.get(key)).getFilterCommand().execute();
                }
            }
        });
        return w;
    }

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        return this.multiGridPreferencesStore;
    }

    public void setMultiGridPreferencesStore(MultiGridPreferencesStore multiGridPreferencesStore) {
        this.multiGridPreferencesStore = multiGridPreferencesStore;
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    private int getGridIndex(String key) {
        if (key == null) {
            return -1;
        }
        ArrayList tabsId = this.multiGridPreferencesStore.getGridsId();
        for (int i = 0; i < tabsId.size(); ++i) {
            if (!key.equals(tabsId.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedTab() {
        int selectedTab = this.getGridIndex(this.getMultiGridPreferencesStore().getSelectedGrid());
        if (selectedTab != -1) {
            this.tabPanel.selectTab(selectedTab);
        } else {
            this.tabPanel.selectTab(0);
        }
    }

    public void saveTabSettings(String key, HashMap<String, Object> params) {
        this.multiGridPreferencesStore.setGridSettings(key, params);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    public void saveNewTabSettings(String key, HashMap<String, Object> params) {
        this.multiGridPreferencesStore.addNewTab(key, params);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    public void setRefreshGridCommand(Command refreshGridCommand) {
        this.refreshGridCommand = refreshGridCommand;
    }

    static interface Binder
    extends UiBinder<Widget, FilterPagedTable> {
    }
}

