/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.github.gwtbootstrap.client.ui.DataGrid;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.Column;

public class SelectionColumn<T>
extends Column<T, Boolean> {
    private final DataGrid<T> dataGrid;

    public static <T> SelectionColumn<T> createAndAddSelectionColumn(DataGrid<T> dataGrid) {
        SelectionColumn<T> selectionColumn = new SelectionColumn<T>(dataGrid);
        dataGrid.addColumn(selectionColumn, SafeHtmlUtils.fromSafeConstant((String)"<br>"));
        return selectionColumn;
    }

    public SelectionColumn(DataGrid<T> dataGrid) {
        super((Cell)new CheckboxCell(true, true));
        this.dataGrid = dataGrid;
        this.addUpdater();
    }

    private void addUpdater() {
        this.setFieldUpdater(new FieldUpdater<T, Boolean>(){

            public void update(int index, T object, Boolean value) {
                SelectionColumn.this.dataGrid.getSelectionModel().setSelected(object, value.booleanValue());
            }
        });
    }

    public Boolean getValue(T object) {
        return this.dataGrid.getSelectionModel().isSelected(object);
    }
}

