/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.NavWidget;
import com.github.gwtbootstrap.client.ui.base.ComplexWidget;
import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.ArrayList;
import java.util.List;

public class UberBreadcrumbs
extends UnorderedList {
    private WidgetCollection children = new WidgetCollection((HasWidgets)this);
    private List<Divider> dividerList = new ArrayList<Divider>();
    private String divider = "/";

    public UberBreadcrumbs() {
        this.setStyleName("breadcrumb");
    }

    public UberBreadcrumbs(Widget ... widgets) {
        this();
        for (Widget widget : widgets) {
            this.add(widget);
        }
    }

    public UberBreadcrumbs(String divider) {
        this();
        this.setDivider(divider);
    }

    public void setDivider(String divider) {
        this.divider = divider == null || divider.isEmpty() ? "/" : divider;
        for (Divider dividerWidget : this.dividerList) {
            dividerWidget.setDivider(this.divider);
        }
    }

    protected void onAttach() {
        if (!this.isOrWasAttached() && this.children.size() > 0) {
            Widget lastWidget = this.children.get(this.children.size() - 1);
            for (Widget w : this.children) {
                Object item = lastWidget.equals(w) ? w : this.getOrCreateListItem(w);
                if (item == null) continue;
                super.add(item);
            }
        }
        super.onAttach();
    }

    public void add(Widget w) {
        w.removeStyleName("active");
        if (!this.isOrWasAttached()) {
            this.children.add(w);
            return;
        }
        if (this.children.size() > 0) {
            super.remove(this.getWidget(this.getWidgetCount() - 1));
            ComplexWidget item = this.getOrCreateListItem(this.children.get(this.children.size() - 1));
            if (item != null) {
                super.add((Widget)item);
            }
        }
        super.add(w);
        this.children.add(w);
    }

    private ComplexWidget getOrCreateListItem(Widget lastWidget) {
        ListItem item = null;
        Divider dividerWidget = new Divider(this.divider);
        if (lastWidget instanceof NavWidget) {
            NavWidget w = (NavWidget)lastWidget;
            if (this.hasDivier((ComplexWidget)w)) {
                return w;
            }
            this.dividerList.add(dividerWidget);
            w.addWidget((Widget)dividerWidget);
            return w;
        }
        if (lastWidget instanceof Dropdown) {
            Dropdown w = (Dropdown)lastWidget;
            if (this.hasDivier((ComplexWidget)w)) {
                return w;
            }
            this.dividerList.add(dividerWidget);
            super.add((Widget)w);
            super.add((Widget)dividerWidget);
            return null;
        }
        item = lastWidget instanceof ListItem ? (ListItem)lastWidget : new ListItem(new Widget[]{lastWidget});
        if (this.hasDivier((ComplexWidget)item)) {
            return item;
        }
        item.add((Widget)dividerWidget);
        this.dividerList.add(dividerWidget);
        return item;
    }

    private boolean hasDivier(ComplexWidget item) {
        for (Widget w : item) {
            if (!(w instanceof Divider)) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Widget w) {
        if (!this.isOrWasAttached() && this.children.contains(w)) {
            this.children.remove(w);
            return true;
        }
        if (this.getWidgetIndex(w) < 0 && !this.children.contains(w)) {
            return false;
        }
        if (this.getWidgetIndex(w) >= 0 && this.children.contains(w)) {
            this.children.remove(w);
            super.remove(w);
        } else if (this.getWidgetIndex(w) >= 0 && !this.children.contains(w)) {
            this.children.remove(this.getWidgetIndex(w));
            super.remove(w);
        } else {
            if (this.getWidgetIndex(w) < 0 && this.children.contains(w)) {
                return this.remove(this.getWidget(this.children.indexOf(w)));
            }
            return false;
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.children = new WidgetCollection((HasWidgets)this);
        this.dividerList.clear();
    }

    private static class Divider
    extends ComplexWidget {
        public Divider(String divider) {
            super("span");
            this.setStyleName("divider");
            this.setDivider(divider);
        }

        public void setDivider(String divider) {
            this.getElement().setInnerText(divider);
        }
    }
}

