/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common.popups;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Close;
import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;

public class BaseModal
extends Modal {
    public BaseModal() {
        this.setMaxHeigth((double)Window.getClientHeight() * 0.75 + "px");
        this.setBackdrop(BackdropType.STATIC);
        this.setKeyboard(true);
        this.setAnimation(true);
        this.setDynamicSafe(true);
        this.setHideOthers(false);
        this.setShowHandler();
        this.setKeyPressHandler();
    }

    private void setKeyPressHandler() {
        this.addDomHandler((EventHandler)this.getEnterDomHandler(), KeyDownEvent.getType());
    }

    protected KeyDownHandler getEnterDomHandler() {
        return new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 13 && BaseModal.this.handleDefaultAction()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
            }
        };
    }

    private void setShowHandler() {
        this.addShownHandler(new ShownHandler(){

            public void onShown(ShownEvent shownEvent) {
                BaseModal.this.setFocus((HasWidgets)BaseModal.this, Boolean.FALSE);
            }
        });
    }

    protected boolean setFocus(HasWidgets container, Boolean found) {
        for (Widget w : container) {
            if (w instanceof Close) continue;
            if (w instanceof Focusable) {
                ((Focusable)w).setFocus(true);
                found = true;
            } else if (w instanceof HasWidgets) {
                found = this.setFocus((HasWidgets)w, found);
            }
            if (!Boolean.TRUE.equals(found)) continue;
            break;
        }
        return found;
    }

    protected boolean handleDefaultAction() {
        for (Widget w : this.getChildren()) {
            if (!(w instanceof ModalFooter)) continue;
            ModalFooter footer = (ModalFooter)w;
            return this.handleModalFooter(footer);
        }
        return false;
    }

    private boolean handleModalFooter(ModalFooter footer) {
        for (Widget fw : footer) {
            Button b;
            if (fw instanceof ModalFooter) {
                return this.handleModalFooter((ModalFooter)fw);
            }
            if (!(fw instanceof Button) || !(b = (Button)fw).getType().equals((Object)ButtonType.PRIMARY)) continue;
            b.fireEvent((GwtEvent)new ClickEvent(){});
            return true;
        }
        return false;
    }
}

