/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.colorpicker;

final class ColorUtils {
    private ColorUtils() {
    }

    static int[] hsl2rgb(int[] hsl) {
        double h = (double)hsl[0] / 360.0;
        double s = (double)hsl[1] / 100.0;
        double l = (double)hsl[2] / 100.0;
        double r = 0.0;
        double g = 0.0;
        if (s > 0.0) {
            if (h >= 1.0) {
                h = 0.0;
            }
            double f = (h *= 6.0) - Math.floor(h);
            double a = Math.round(l * 255.0 * (1.0 - s));
            double b = Math.round(l * 255.0 * (1.0 - s * f));
            double c = Math.round(l * 255.0 * (1.0 - s * (1.0 - f)));
            l = Math.round(l * 255.0);
            switch ((int)Math.floor(h)) {
                case 0: {
                    r = l;
                    g = c;
                    b = a;
                    break;
                }
                case 1: {
                    r = b;
                    g = l;
                    b = a;
                    break;
                }
                case 2: {
                    r = a;
                    g = l;
                    b = c;
                    break;
                }
                case 3: {
                    r = a;
                    g = b;
                    b = l;
                    break;
                }
                case 4: {
                    r = c;
                    g = a;
                    b = l;
                    break;
                }
                case 5: {
                    r = l;
                    g = a;
                }
            }
            return new int[]{(int)Math.round(r), (int)Math.round(g), (int)Math.round(b)};
        }
        l = Math.round(l * 255.0);
        return new int[]{(int)l, (int)l, (int)l};
    }

    static String toHex(int v) {
        v = Math.min(Math.max(v, 0), 255);
        return String.valueOf("0123456789abcdef".charAt((v - v % 16) / 16)) + String.valueOf("0123456789abcdef".charAt(v % 16));
    }

    static String rgb2hex(int[] rgb) {
        return ColorUtils.toHex(rgb[0]) + ColorUtils.toHex(rgb[1]) + ColorUtils.toHex(rgb[2]);
    }

    static String rgb2hex(int r, int g, int b) {
        return ColorUtils.rgb2hex(new int[]{r, g, b});
    }

    static String hsl2hex(int[] hsl) {
        return ColorUtils.rgb2hex(ColorUtils.hsl2rgb(hsl));
    }

    static String hsl2hex(int h, int s, int l) {
        return ColorUtils.hsl2hex(new int[]{h, s, l});
    }

    static int[] rgb2hsl(int[] rgb) {
        double max = Math.max(Math.max(rgb[0], rgb[1]), rgb[2]);
        double delta = max - (double)Math.min(Math.min(rgb[0], rgb[1]), rgb[2]);
        double h = 0.0;
        int s = 0;
        int l = (int)Math.round(max * 100.0 / 255.0);
        if (max != 0.0) {
            s = (int)Math.round(delta * 100.0 / max);
            h = max == (double)rgb[0] ? (double)(rgb[1] - rgb[2]) / delta : (max == (double)rgb[1] ? (double)(rgb[2] - rgb[0]) / delta + 2.0 : (double)(rgb[0] - rgb[1]) / delta + 4.0);
            if ((h = Math.min((double)Math.round(h * 60.0), 360.0)) < 0.0) {
                h += 360.0;
            }
        }
        return new int[]{(int)Math.round(h), Math.round(s), l};
    }

    static int[] getRGB(String color) {
        return new int[]{Integer.parseInt(color.substring(0, 2), 16), Integer.parseInt(color.substring(2, 4), 16), Integer.parseInt(color.substring(4, 6), 16)};
    }
}

