/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.github.gwtbootstrap.client.ui.DropdownTab;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabLink;
import com.github.gwtbootstrap.client.ui.TabPane;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.common.MultiPageEditor;
import org.uberfire.ext.widgets.common.client.common.Page;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public class MultiPageEditorView
extends Composite
implements RequiresResize {
    private static final int MARGIN = 20;
    final TabPanel tabPanel;
    private int maxDropdownTabLinkWidth = 0;
    private boolean alreadyScheduled = false;

    public MultiPageEditorView() {
        this(MultiPageEditor.TabPosition.BELOW);
    }

    public MultiPageEditorView(final MultiPageEditor.TabPosition tabPosition) {
        this.tabPanel = new TabPanel(){
            {
                this.setTabPosition(tabPosition.getPosition());
                this.addShownHandler(new TabPanel.ShownEvent.Handler(){

                    public void onShow(TabPanel.ShownEvent e) {
                        try {
                            ((Page.PageView)((LayoutPanel)e.getRelatedTarget().getTabPane().getWidget(0)).getWidget(0)).onLostFocus();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.addShowHandler(new TabPanel.ShowEvent.Handler(){

                    public void onShow(TabPanel.ShowEvent e) {
                        try {
                            Page.PageView widget = (Page.PageView)((LayoutPanel)e.getTarget().getTabPane().getWidget(0)).getWidget(0);
                            MultiPageEditorView.this.scheduleResize((Widget)widget);
                            widget.onFocus();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        this.initWidget((Widget)this.tabPanel);
    }

    protected void scheduleResize(Widget widget) {
        if (widget instanceof RequiresResize) {
            final RequiresResize requiresResize = (RequiresResize)widget;
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    requiresResize.onResize();
                }
            });
        }
    }

    public void addPage(Page page) {
        Tab tab = this.createTab(page.getLabel(), (IsWidget)page.getView(), false, 0, 0);
        this.tabPanel.add((IsWidget)tab);
        if (this.getTabs().getWidgetCount() == 1) {
            this.tabPanel.selectTab(0);
        }
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MultiPageEditorView.this.onResize();
            }
        });
    }

    public void selectPage(int index) {
        this.tabPanel.selectTab(index);
    }

    public int selectedPage() {
        return this.tabPanel.getSelectedTab();
    }

    public void clear() {
        this.tabPanel.clear();
    }

    public void shrinkTabBar() {
        Widget lastTab = this.getLastTab();
        if (lastTab instanceof TabLink) {
            this.maxDropdownTabLinkWidth = 0;
            TabLink tab = (TabLink)lastTab;
            DropdownTab dropdown = new DropdownTab(CommonConstants.INSTANCE.More()){
                {
                    this.setDropup(true);
                }
            };
            Tab clonedTab = this.cloneTab(tab, false, true);
            if (clonedTab.isActive()) {
                dropdown.setText(CommonConstants.INSTANCE.Active() + " " + clonedTab.asTabLink().getText());
                dropdown.addStyleName("active");
            }
            dropdown.add((IsWidget)clonedTab);
            this.tabPanel.add((Widget)dropdown);
            this.tabPanel.remove((Widget)tab);
            this.scheduleResize();
        } else if (lastTab instanceof DropdownTab) {
            TabLink lastTabLink = (TabLink)this.getBeforeLastTab();
            if (lastTabLink == null) {
                return;
            }
            Tab clonedTab = this.cloneTab(lastTabLink, false, true);
            DropdownTab dropdown = this.cloneDropdown((DropdownTab)lastTab, -1);
            if (clonedTab.isActive()) {
                dropdown.setText(CommonConstants.INSTANCE.Active() + " " + clonedTab.asTabLink().getText());
                dropdown.addStyleName("active");
            }
            dropdown.add((IsWidget)clonedTab);
            this.tabPanel.add((Widget)dropdown);
            this.tabPanel.remove((Widget)lastTabLink);
            this.tabPanel.remove(lastTab);
            this.scheduleResize();
        }
    }

    private void scheduleResize() {
        if (this.alreadyScheduled) {
            return;
        }
        this.alreadyScheduled = true;
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                MultiPageEditorView.this.onResize();
                MultiPageEditorView.this.alreadyScheduled = false;
            }
        });
    }

    public void expandTabBar() {
        DropdownTab dropdown = (DropdownTab)this.getLastTab();
        int index = dropdown.getTabList().size() - 1;
        TabLink tab = ((Tab)dropdown.getTabList().get(index)).asTabLink();
        Tab newTab = this.cloneTab(tab, true, false);
        this.tabPanel.add((IsWidget)newTab);
        if (dropdown.getTabList().size() > 2) {
            this.tabPanel.add((Widget)this.cloneDropdown(dropdown, index));
        } else if (dropdown.getTabList().size() == 2) {
            TabLink _tab = ((Tab)dropdown.getTabList().get(index - 1)).asTabLink();
            this.tabPanel.add((IsWidget)this.cloneTab(_tab, true, false));
            this.maxDropdownTabLinkWidth = 0;
        }
        this.tabPanel.remove((Widget)dropdown);
        this.scheduleResize();
    }

    public Tab createTab(final String label, final IsWidget widget, final boolean isActive, final int width, final int height) {
        final Tab tab = new Tab(){
            {
                this.setHeading(label);
                this.setActive(isActive);
            }
        };
        tab.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (tab.asTabLink().getParent().getParent() instanceof DropdownTab) {
                    DropdownTab dropdownTab = (DropdownTab)tab.asTabLink().getParent().getParent();
                    dropdownTab.setText(CommonConstants.INSTANCE.Active() + " " + label);
                    dropdownTab.addStyleName("active");
                } else {
                    Widget lastTab = MultiPageEditorView.this.getLastTab();
                    if (lastTab instanceof DropdownTab) {
                        ((DropdownTab)lastTab).setText(CommonConstants.INSTANCE.More());
                    }
                }
            }
        });
        final LayoutPanel flowPanel = new LayoutPanel(){
            {
                this.add(widget);
                this.setPixelSize(width, height);
            }
        };
        tab.add((Widget)flowPanel);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (MultiPageEditorView.this.getParent() != null) {
                    flowPanel.setPixelSize(MultiPageEditorView.this.getParent().getOffsetWidth(), MultiPageEditorView.this.getParent().getOffsetHeight() - MultiPageEditorView.this.getTabHeight());
                }
            }
        });
        return tab;
    }

    public Tab cloneTab(TabLink tabLink, boolean fromDropdown, boolean toDropdown) {
        String heading = tabLink.getText();
        Widget content = ((ComplexPanel)tabLink.getTabPane().getWidget(0)).getWidget(0);
        if (!fromDropdown && toDropdown && tabLink.getOffsetWidth() > this.maxDropdownTabLinkWidth) {
            this.maxDropdownTabLinkWidth = tabLink.getOffsetWidth();
        }
        return this.createTab(heading, (IsWidget)content, tabLink.isActive(), content.getOffsetWidth(), content.getOffsetHeight());
    }

    private DropdownTab cloneDropdown(DropdownTab original, int excludedIndex) {
        DropdownTab newDropdown = new DropdownTab(original.getText()){
            {
                this.setDropup(true);
            }
        };
        boolean isAnyTabActive = false;
        for (int i = 0; i < original.getTabList().size(); ++i) {
            Tab currentTab = (Tab)original.getTabList().get(i);
            if (i == excludedIndex) continue;
            if (!isAnyTabActive) {
                isAnyTabActive = currentTab.isActive();
            }
            newDropdown.add((IsWidget)this.cloneTab(currentTab.asTabLink(), true, true));
        }
        if (isAnyTabActive) {
            newDropdown.addStyleName("active");
        } else {
            newDropdown.setText(CommonConstants.INSTANCE.More());
        }
        return newDropdown;
    }

    public void onResize() {
        Widget parent = this.getParent();
        if (parent != null) {
            int width = parent.getOffsetWidth();
            int height = parent.getOffsetHeight();
            this.setPixelSize(width, height);
            if (width == 0 && height == 0) {
                return;
            }
            ComplexPanel content = this.getTabContent();
            for (int i = 0; i < content.getWidgetCount(); ++i) {
                Widget widget = content.getWidget(i);
                if (!(widget instanceof TabPane)) continue;
                TabPane tabPane = (TabPane)widget;
                LayoutPanel flowPanel = (LayoutPanel)tabPane.getWidget(0);
                flowPanel.setPixelSize(width, height - this.getTabHeight());
                for (int iChild = 0; iChild < tabPane.getWidgetCount(); ++iChild) {
                    Widget childWidget = tabPane.getWidget(iChild);
                    if (!(childWidget instanceof RequiresResize)) continue;
                    ((RequiresResize)childWidget).onResize();
                }
            }
            ComplexPanel tabs = this.getTabs();
            if (tabs != null && tabs.getWidgetCount() > 0) {
                Widget firstTabItem = tabs.getWidget(0);
                Widget lastTabItem = this.getLastTab();
                if (width < this.getTabBarWidth() || tabs.getOffsetHeight() > firstTabItem.getOffsetHeight()) {
                    this.shrinkTabBar();
                } else if (lastTabItem instanceof DropdownTab && this.getTabBarWidth() + this.getLastTab().getOffsetWidth() < width) {
                    this.expandTabBar();
                }
            }
        }
    }

    private int getTabHeight() {
        return this.tabPanel.getWidget(1).getOffsetHeight() + 20;
    }

    public ComplexPanel getTabContent() {
        return (ComplexPanel)this.tabPanel.getWidget(0);
    }

    private ComplexPanel getTabs() {
        return (ComplexPanel)this.tabPanel.getWidget(1);
    }

    private Widget getLastTab() {
        ComplexPanel tabs = this.getTabs();
        return tabs.getWidget(tabs.getWidgetCount() - 1);
    }

    private Widget getBeforeLastTab() {
        ComplexPanel tabs = this.getTabs();
        int index = tabs.getWidgetCount() - 2;
        if (index < 0) {
            return null;
        }
        return tabs.getWidget(index);
    }

    private int getTabBarWidth() {
        ComplexPanel tabs = this.getTabs();
        int width = 0;
        for (Widget currentTab : tabs) {
            width += currentTab.getOffsetWidth();
        }
        int margin = 42;
        if (this.getLastTab() instanceof DropdownTab) {
            margin = this.maxDropdownTabLinkWidth;
        }
        return width + margin;
    }
}

