/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;
import org.uberfire.ext.widgets.common.client.tables.ColumnPicker;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnPickerTest {
    @InjectMocks
    ColumnPicker columnPicker;
    @GwtMock
    DataGrid dataGrid;

    @Before
    public void setUp() throws Exception {
        final ArrayList columns = new ArrayList();
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                columns.add((Column)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.dataGrid)).addColumn((Column)Mockito.any(Column.class), (Header)Mockito.any(Header.class));
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns.size();
            }
        }).when((Object)this.dataGrid)).getColumnCount();
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                columns.remove(0);
                return null;
            }
        }).when((Object)this.dataGrid)).removeColumn(0);
    }

    @Test
    public void testAddRemoveColumn() {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getDataStoreName()).thenReturn((Object)"id");
        ColumnMeta meta = new ColumnMeta(column, "caption");
        meta.setHeader((Header)new TextHeader("header"));
        this.columnPicker.addColumn(meta);
        Assert.assertTrue((boolean)this.columnPicker.getColumnMetaList().contains(meta));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column, meta.getHeader());
        Assert.assertEquals((long)1L, (long)this.dataGrid.getColumnCount());
        this.columnPicker.removeColumn(meta);
        Assert.assertFalse((boolean)this.columnPicker.getColumnMetaList().contains(meta));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).removeColumn(0);
        Assert.assertEquals((long)0L, (long)this.dataGrid.getColumnCount());
    }

    @Test
    public void testSortColumn() {
        Column column1 = (Column)Mockito.mock(Column.class);
        ColumnMeta meta1 = new ColumnMeta(column1, "caption1", true, 1);
        meta1.setHeader((Header)new TextHeader("header1"));
        Column column0 = (Column)Mockito.mock(Column.class);
        ColumnMeta meta0 = new ColumnMeta(column0, "caption0", true, 0);
        meta0.setHeader((Header)new TextHeader("header0"));
        this.columnPicker.addColumns(Arrays.asList(meta1, meta0));
        Assert.assertEquals((long)2L, (long)this.columnPicker.getColumnMetaList().size());
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column0, meta0.getHeader());
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column1, meta1.getHeader());
        Assert.assertEquals((long)2L, (long)this.dataGrid.getColumnCount());
    }

    @Test
    public void testColumnPreference() {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getDataStoreName()).thenReturn((Object)"id");
        ColumnMeta meta = new ColumnMeta(column, "caption");
        meta.setHeader((Header)new TextHeader("header"));
        this.columnPicker.addColumn(meta);
        List columnsState = this.columnPicker.getColumnsState();
        Assert.assertEquals((long)1L, (long)columnsState.size());
        GridColumnPreference preference = (GridColumnPreference)columnsState.get(0);
        Assert.assertEquals((Object)preference.getName(), (Object)column.getDataStoreName());
        Assert.assertEquals((long)0L, (long)preference.getPosition().intValue());
    }
}

