/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.uberfire.ext.widgets.common.client.tables.SortDirection;
import org.uberfire.ext.widgets.common.client.tables.SortableHeader;

public class SortableHeaderGroup<T extends Comparable> {
    private final DataGrid<T> dataGrid;
    private List<SortableHeader<T, ?>> sortOrderList = new LinkedList();

    public SortableHeaderGroup(DataGrid<T> dataGrid) {
        this.dataGrid = dataGrid;
    }

    public void headerClicked(SortableHeader<T, ?> header) {
        this.updateSortOrder(header);
        this.dataGrid.redrawHeaders();
        this.updateData();
    }

    private void updateSortOrder(SortableHeader<T, ?> header) {
        int index = this.sortOrderList.indexOf(header);
        if (index == 0) {
            if (header.getSortDirection() != SortDirection.ASCENDING) {
                header.setSortDirection(SortDirection.ASCENDING);
            } else {
                header.setSortDirection(SortDirection.DESCENDING);
            }
        } else {
            if (index > 0) {
                this.sortOrderList.remove(index);
            }
            header.setSortDirection(SortDirection.ASCENDING);
            this.sortOrderList.add(0, header);
            int sortIndex = 0;
            for (SortableHeader<T, ?> sortableHeader : this.sortOrderList) {
                sortableHeader.setSortIndex(sortIndex);
                ++sortIndex;
            }
        }
    }

    private void updateData() {
        ArrayList displayedItems = new ArrayList(this.dataGrid.getDisplayedItems());
        Collections.sort(displayedItems, new Comparator<T>(){

            @Override
            public int compare(T leftRow, T rightRow) {
                for (SortableHeader sortableHeader : SortableHeaderGroup.this.sortOrderList) {
                    Comparable rightColumnValue;
                    Comparable leftColumnValue = (Comparable)sortableHeader.getColumn().getValue(leftRow);
                    int comparison = leftColumnValue == (rightColumnValue = (Comparable)sortableHeader.getColumn().getValue(rightRow)) ? 0 : (leftColumnValue == null ? -1 : (rightColumnValue == null ? 1 : leftColumnValue.compareTo(rightColumnValue)));
                    if (comparison == 0) continue;
                    switch (sortableHeader.getSortDirection()) {
                        case ASCENDING: {
                            break;
                        }
                        case DESCENDING: {
                            comparison = -comparison;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Sorting can only be enabled for ASCENDING or DESCENDING, not sortDirection (" + (Object)((Object)sortableHeader.getSortDirection()) + ") .");
                        }
                    }
                    return comparison;
                }
                return leftRow.compareTo(rightRow);
            }
        });
        this.dataGrid.setRowData(0, displayedItems);
        this.dataGrid.redraw();
    }
}

