/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.colorpicker;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorUtils;
import org.uberfire.ext.widgets.common.client.colorpicker.HueChangedEvent;
import org.uberfire.ext.widgets.common.client.colorpicker.HueChangedHandler;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.Canvas;
import org.uberfire.ext.widgets.common.client.colorpicker.canvas.RenderingContext;

public class HuePicker
extends Composite {
    private Canvas canvas = new Canvas();
    private int handleY = 90;
    private boolean mouseDown;

    public HuePicker() {
        this.canvas.setStylePrimaryName("subshell-HuePicker");
        this.canvas.setCanvasSize(26, 180);
        this.initWidget((Widget)this.canvas);
        this.canvas.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                HuePicker.this.handleY = event.getRelativeY((Element)HuePicker.this.canvas.getElement());
                HuePicker.this.drawGradient();
                HuePicker.this.fireHueChanged(HuePicker.this.getHue());
                HuePicker.this.mouseDown = true;
            }
        });
        this.canvas.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (HuePicker.this.mouseDown) {
                    HuePicker.this.handleY = event.getRelativeY((Element)HuePicker.this.canvas.getElement());
                    HuePicker.this.drawGradient();
                    HuePicker.this.fireHueChanged(HuePicker.this.getHue());
                }
            }
        });
        this.canvas.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                HuePicker.this.mouseDown = false;
            }
        });
        this.canvas.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                HuePicker.this.mouseDown = false;
            }
        });
    }

    protected void onAttach() {
        super.onAttach();
        this.drawGradient();
    }

    private void drawGradient() {
        RenderingContext ctx = this.canvas.getContext();
        ctx.setFillStyle("#ffffff");
        ctx.fillRect(0, 0, 26, 180);
        for (int y = 0; y <= 179; ++y) {
            String hex = ColorUtils.hsl2hex(y * 2, 100, 100);
            ctx.setFillStyle("#" + hex);
            ctx.fillRect(3, y, 20, 1);
        }
        if (this.handleY >= 0) {
            ctx.setFillStyle("#000000");
            ctx.beginPath();
            ctx.moveTo(3, this.handleY);
            ctx.lineTo(0, this.handleY - 3);
            ctx.lineTo(0, this.handleY + 3);
            ctx.closePath();
            ctx.fill();
            ctx.moveTo(23, this.handleY);
            ctx.lineTo(26, this.handleY - 3);
            ctx.lineTo(26, this.handleY + 3);
            ctx.closePath();
            ctx.fill();
        }
    }

    public HandlerRegistration addHueChangedHandler(HueChangedHandler handler) {
        return this.addHandler(handler, HueChangedEvent.getType());
    }

    private void fireHueChanged(int hue) {
        this.fireEvent(new HueChangedEvent(hue));
    }

    public int getHue() {
        return this.handleY * 2;
    }

    public void setHue(int hue) {
        this.handleY = (int)Math.min(Math.max((double)Math.round((double)hue / 2.0), 0.0), 179.0);
        this.drawGradient();
        this.fireHueChanged(hue);
    }
}

