/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.accordion;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.shared.event.HiddenEvent;
import org.gwtbootstrap3.client.shared.event.HiddenHandler;
import org.gwtbootstrap3.client.shared.event.ShowEvent;
import org.gwtbootstrap3.client.shared.event.ShowHandler;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.base.AbstractTextWidget;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Strong;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public class TriggerWidget
extends PanelHeader {
    private final FlexTable table = new FlexTable();
    private final Icon caret;

    public TriggerWidget(String description) {
        this(description, true);
    }

    public TriggerWidget(String description, boolean isCaretDown) {
        this.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.caret = this.makeIcon(isCaretDown ? IconType.CARET_DOWN : IconType.CARET_UP, CommonConstants.INSTANCE.ClickToDisplay0(description));
        this.table.setWidget(0, 0, this.buildDescription(description));
        this.table.setHTML(0, 1, "&nbsp;&nbsp;");
        this.table.setWidget(0, 2, (Widget)this.caret);
        this.insert((Widget)this.table, 0);
    }

    public TriggerWidget(IsWidget icon, String description) {
        this(icon, description, true);
    }

    public TriggerWidget(IsWidget icon, String description, boolean isCaretDown) {
        this.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.caret = this.makeIcon(isCaretDown ? IconType.CARET_DOWN : IconType.CARET_UP, CommonConstants.INSTANCE.ClickToDisplay0(description));
        if (icon == null) {
            this.table.setWidget(0, 0, this.buildDescription(description));
            this.table.setHTML(0, 1, "&nbsp;&nbsp;");
            this.table.setWidget(0, 2, (Widget)this.caret);
        } else {
            this.table.setWidget(0, 0, icon);
            this.table.setHTML(0, 1, "&nbsp;&nbsp;");
            this.table.setWidget(0, 2, this.buildDescription(description));
            this.table.setHTML(0, 3, "&nbsp;&nbsp;");
            this.table.setWidget(0, 4, (Widget)this.caret);
        }
        this.insert((Widget)this.table, 0);
    }

    public void setDataTargetWidget(Widget widget) {
        super.setDataTargetWidget(widget);
        if (widget instanceof PanelCollapse) {
            PanelCollapse collapse = (PanelCollapse)widget;
            collapse.addShowHandler(new ShowHandler(){

                public void onShow(ShowEvent showEvent) {
                    TriggerWidget.this.caret.setType(IconType.CARET_UP);
                }
            });
            collapse.addHiddenHandler(new HiddenHandler(){

                public void onHidden(HiddenEvent event) {
                    TriggerWidget.this.caret.setType(IconType.CARET_DOWN);
                }
            });
        }
    }

    private Icon makeIcon(IconType iconType, final String tooltip) {
        return new Icon(iconType){
            {
                super(x0);
                this.setTitle(tooltip);
            }
        };
    }

    private Widget buildDescription(final String caption) {
        return new AbstractTextWidget((Element)Document.get().createSpanElement()){
            {
                super(x0);
                this.addStyleName("text-uppercase");
                this.setTitle(CommonConstants.INSTANCE.ClickToDisplay0(caption));
                this.setHTML(new Strong(caption).getElement().getString());
            }
        };
    }
}

