/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.common.AbstractLazyStackPanelHeader;
import org.uberfire.ext.widgets.common.client.common.LoadContentCommand;

public class LazyStackPanelRow
extends VerticalPanel {
    private final AbstractLazyStackPanelHeader header;
    private LoadContentCommand contentLoad;
    private Widget contentWidget = null;
    private SimplePanel contentPanel = new SimplePanel();
    private static final int ANIMATION_DURATION = 350;
    private boolean expanded;

    public LazyStackPanelRow(AbstractLazyStackPanelHeader titleWidget, LoadContentCommand contentLoad, boolean expanded) {
        this.setWidth("100%");
        this.expanded = expanded;
        this.header = titleWidget;
        this.contentLoad = contentLoad;
        this.init();
    }

    public LazyStackPanelRow(AbstractLazyStackPanelHeader titleWidget, LoadContentCommand contentLoad) {
        this(titleWidget, contentLoad, false);
    }

    private void init() {
        this.clear();
        this.add((Widget)this.header);
        if (this.contentWidget != null) {
            this.contentWidget.setVisible(this.expanded);
        }
    }

    public AbstractLazyStackPanelHeader getHeader() {
        return this.header;
    }

    public SimplePanel getContentPanel() {
        return this.contentPanel;
    }

    public void expand() {
        this.expanded = true;
        if (this.contentWidget == null) {
            this.contentWidget = this.contentLoad.load();
            this.contentPanel.add(this.contentWidget);
        }
        this.contentPanel.setVisible(true);
        this.doAnimation(true);
    }

    public void compress() {
        this.expanded = false;
        this.contentPanel.setVisible(true);
        this.doAnimation(false);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void doAnimation(boolean isExpanding) {
        if (this.contentPanel.getWidget() != null) {
            ContentAnimation contentAnimation = new ContentAnimation(this.contentPanel);
            contentAnimation.setExpanding(isExpanding);
            contentAnimation.run(350);
        }
    }

    private static class ContentAnimation
    extends Animation {
        private boolean isExpanding;
        private SimplePanel content;
        private int height;

        ContentAnimation(SimplePanel content) {
            this.content = content;
            this.height = content.getOffsetHeight();
        }

        void setExpanding(boolean isExpanding) {
            this.isExpanding = isExpanding;
        }

        protected void onUpdate(double progress) {
            if (!this.isExpanding) {
                progress = 1.0 - progress;
            }
            int h = (int)((double)this.height * progress);
            this.content.setHeight(h + "px");
        }

        protected void onStart() {
            this.content.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
            super.onStart();
        }

        protected void onComplete() {
            super.onComplete();
            this.content.setVisible(this.isExpanding);
            this.content.getElement().getStyle().setOverflow(Style.Overflow.VISIBLE);
            this.content.setHeight("100%");
        }
    }
}

