/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.mvp.Command;

@Dependent
public class LiveSearchDropDown
implements IsWidget {
    View view;
    int maxItems = 10;
    LiveSearchService searchService = null;
    boolean searchEnabled = true;
    boolean searchCacheEnabled = true;
    Map<String, List<String>> searchCache = new HashMap<String, List<String>>();
    String selectedItem = null;
    String lastSearch = null;
    String searchHint = null;
    String selectorHint = null;
    String notFoundMessage = null;
    Command onChange;

    @Inject
    public LiveSearchDropDown(View view) {
        this.view = view;
        view.init(this);
        this.searchHint = view.getDefaultSearchHintI18nMessage();
        this.selectorHint = view.getDefaultSelectorHintI18nMessage();
        this.notFoundMessage = view.getDefaultNotFoundI18nMessage();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
        this.view.setSearchEnabled(searchEnabled);
    }

    public void setSelectorHint(String text) {
        this.selectorHint = text;
        this.view.setDropDownText(text);
    }

    public void setSearchHint(String text) {
        this.searchHint = text;
        this.view.setSearchHint(text);
    }

    public void setNotFoundMessage(String noItemsMessage) {
        this.notFoundMessage = noItemsMessage;
    }

    public void setOnChange(Command onChange) {
        this.onChange = onChange;
    }

    public void setSearchService(LiveSearchService searchService) {
        this.searchService = searchService;
    }

    public boolean isSearchCacheEnabled() {
        return this.searchCacheEnabled;
    }

    public void setSearchCacheEnabled(boolean searchCacheEnabled) {
        this.searchCacheEnabled = searchCacheEnabled;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setWidth(int minWidth) {
        this.view.setWidth(minWidth);
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem;
        this.view.setSelectedItem(selectedItem);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void clear() {
        this.lastSearch = null;
        this.view.clearSearch();
        this.view.clearItems();
        this.view.setDropDownText(this.selectorHint);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void search(String pattern) {
        if (this.lastSearch == null || !this.lastSearch.equals(pattern)) {
            String string = this.lastSearch = pattern != null ? pattern : "";
            if (this.searchCacheEnabled && this.searchCache.containsKey(this.lastSearch)) {
                this.showItemList(this.getFromSearchCache(this.lastSearch));
            } else {
                this.doSearch(pattern);
            }
        }
    }

    protected void doSearch(String pattern) {
        this.view.searchInProgress(this.searchHint);
        this.searchService.search(this.lastSearch, this.maxItems, itemList -> {
            this.addToSearchCache(pattern, itemList);
            this.showItemList(itemList);
            this.view.searchFinished();
        });
    }

    protected List<String> getFromSearchCache(String pattern) {
        return this.searchCache.get(pattern);
    }

    protected void addToSearchCache(String pattern, List<String> itemList) {
        this.searchCache.put(pattern, itemList);
    }

    public void showItemList(List<String> itemList) {
        this.view.clearItems();
        if (itemList.isEmpty()) {
            this.view.noItems(this.notFoundMessage);
        }
        for (String i : itemList) {
            this.view.addItem(i);
        }
    }

    void onItemsShown() {
        Scheduler.get().scheduleDeferred(() -> this.search(this.lastSearch));
    }

    void onItemSelected(String item) {
        this.selectedItem = item;
        this.view.setDropDownText(item);
        if (this.onChange != null) {
            this.onChange.execute();
        }
    }

    public static interface View
    extends UberView<LiveSearchDropDown> {
        public void clearItems();

        public void noItems(String var1);

        public void addItem(String var1);

        public void setSelectedItem(String var1);

        public void setSearchEnabled(boolean var1);

        public void setSearchHint(String var1);

        public void clearSearch();

        public void searchInProgress(String var1);

        public void searchFinished();

        public void setDropDownText(String var1);

        public void setWidth(int var1);

        public void setMaxHeight(int var1);

        public String getDefaultSearchHintI18nMessage();

        public String getDefaultSelectorHintI18nMessage();

        public String getDefaultNotFoundI18nMessage();
    }
}

