/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

@Dependent
@Templated
public class LiveSearchDropDownView
extends Composite
implements LiveSearchDropDown.View {
    @Inject
    @DataField
    Div mainPanel;
    @Inject
    @DataField
    Div dropDownPanel;
    @Inject
    @DataField
    Button dropDownButton;
    @Inject
    @DataField
    Span dropDownText;
    @Inject
    @DataField
    Div searchPanel;
    @Inject
    @DataField
    Input searchInput;
    @Inject
    @DataField
    UnorderedList dropDownMenu;
    @Inject
    @DataField
    Div spinnerPanel;
    @Inject
    @DataField
    Span spinnerText;
    LiveSearchDropDown presenter;

    public void init(LiveSearchDropDown presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.dropDownMenu.getStyle().setProperty("max-height", maxHeight + "px");
    }

    @Override
    public void setWidth(int minWidth) {
        this.dropDownButton.getStyle().setProperty("width", minWidth + "px");
        this.dropDownPanel.getStyle().setProperty("width", minWidth + "px");
    }

    @Override
    public void setSearchEnabled(boolean enabled) {
        this.searchPanel.getStyle().removeProperty("display");
        if (!enabled) {
            this.searchPanel.getStyle().setProperty("display", "none");
        }
    }

    @Override
    public void clearItems() {
        this.removeAllChildren((org.jboss.errai.common.client.dom.Element)this.dropDownMenu);
    }

    @Override
    public void noItems(String msg) {
        this.removeAllChildren((org.jboss.errai.common.client.dom.Element)this.dropDownMenu);
        SpanElement span = Document.get().createSpanElement();
        span.setInnerText(msg);
        span.getStyle().setPropertyPx("marginLeft", 10);
        this.dropDownMenu.appendChild((org.jboss.errai.common.client.dom.Node)span);
    }

    @Override
    public void addItem(String item) {
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setInnerText(item);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                this.presenter.onItemSelected(item);
            }
        });
        LIElement li = Document.get().createLIElement();
        li.appendChild((Node)anchor);
        this.dropDownMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
    }

    @Override
    public void setSelectedItem(String selectedItem) {
        this.dropDownText.setTextContent(selectedItem);
    }

    @Override
    public void setDropDownText(String text) {
        this.dropDownText.setTextContent(text);
    }

    @Override
    public void clearSearch() {
        this.searchInput.setValue("");
    }

    @Override
    public void setSearchHint(String text) {
        this.searchInput.setAttribute("placeholder", text);
    }

    @Override
    public void searchInProgress(String msg) {
        this.spinnerText.setTextContent(msg);
        this.spinnerPanel.getStyle().removeProperty("display");
        this.dropDownMenu.getStyle().setProperty("display", "none");
    }

    @Override
    public void searchFinished() {
        this.spinnerPanel.getStyle().setProperty("display", "none");
        this.dropDownMenu.getStyle().removeProperty("display");
    }

    @Override
    public String getDefaultSearchHintI18nMessage() {
        return CommonConstants.INSTANCE.liveSearchHint();
    }

    @Override
    public String getDefaultSelectorHintI18nMessage() {
        return CommonConstants.INSTANCE.liveSearchSelectorHint();
    }

    @Override
    public String getDefaultNotFoundI18nMessage() {
        return CommonConstants.INSTANCE.liveSearchNotFoundMessage();
    }

    private void removeAllChildren(org.jboss.errai.common.client.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int lenght = nodeList.getLength();
        for (int i = 0; i < lenght; ++i) {
            element.removeChild(nodeList.item(0));
        }
    }

    @EventHandler(value={"searchInput"})
    void onSearchChanged(KeyUpEvent event) {
        String pattern = this.searchInput.getValue();
        this.presenter.search(pattern);
    }

    @EventHandler(value={"searchInput"})
    void onSearchClick(ClickEvent event) {
        event.stopPropagation();
    }

    @EventHandler(value={"dropDownButton"})
    void onDropDownClick(ClickEvent event) {
        this.presenter.onItemsShown();
    }

    @EventHandler(value={"searchInput"})
    void onSearchOver(MouseOverEvent event) {
        this.searchInput.focus();
    }
}

