/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.Divider;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

public class RefreshSelectorMenuBuilder
implements MenuFactory.CustomMenuBuilder {
    private final CommonConstants constants = CommonConstants.INSTANCE;
    private SupportsRefreshInterval supportsRefreshInterval;
    private final DropDownMenu menuDropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
    private final Button menuButton = (Button)GWT.create(Button.class);
    private final ButtonGroup buttonGroup = (ButtonGroup)GWT.create(ButtonGroup.class);

    public RefreshSelectorMenuBuilder(SupportsRefreshInterval supportsRefreshInterval) {
        this.supportsRefreshInterval = supportsRefreshInterval;
        this.setupMenuButton();
        this.setupMenuDropDown();
        this.setupMenuButtonGroup();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return RefreshSelectorMenuBuilder.this.buttonGroup;
            }

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean enabled) {
            }
        };
    }

    protected void setupMenuButtonGroup() {
        this.buttonGroup.add((Widget)this.menuButton);
        this.buttonGroup.add((Widget)this.menuDropDownMenu);
    }

    protected void setupMenuButton() {
        this.menuButton.setDataToggle(Toggle.DROPDOWN);
        this.menuButton.setIcon(IconType.COG);
        this.menuButton.setTitle(this.constants.AutoRefresh());
        this.menuButton.setSize(ButtonSize.SMALL);
    }

    protected void setupMenuDropDown() {
        this.menuDropDownMenu.setPull(Pull.RIGHT);
    }

    protected AnchorListItem createTimeSelector(int time, String name, int configuredSeconds, final AnchorListItem refreshDisableButton) {
        final AnchorListItem oneMinuteRadioButton = (AnchorListItem)GWT.create(AnchorListItem.class);
        oneMinuteRadioButton.setText(name);
        oneMinuteRadioButton.setIconFixedWidth(true);
        final int selectedRefreshTime = time;
        if (configuredSeconds == selectedRefreshTime) {
            oneMinuteRadioButton.setIcon(IconType.CHECK);
        }
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(IconType.CHECK);
                RefreshSelectorMenuBuilder.this.supportsRefreshInterval.onUpdateRefreshInterval(true, selectedRefreshTime);
                refreshDisableButton.setActive(false);
                refreshDisableButton.setEnabled(true);
                refreshDisableButton.setText(RefreshSelectorMenuBuilder.this.constants.Disable_autorefresh());
            }
        });
        return oneMinuteRadioButton;
    }

    public void loadOptions(int configuredSeconds) {
        final AnchorListItem resetButton = new AnchorListItem(this.constants.Disable_autorefresh());
        if (configuredSeconds > 10) {
            this.supportsRefreshInterval.onUpdateRefreshInterval(true, configuredSeconds);
            resetButton.setEnabled(true);
        } else {
            this.supportsRefreshInterval.onUpdateRefreshInterval(false, 0);
            resetButton.setEnabled(false);
            resetButton.setText(this.constants.Autorefresh_Disabled());
        }
        final AnchorListItem oneMinuteRadioButton = this.createTimeSelector(60, "1 " + this.constants.Minute(), configuredSeconds, resetButton);
        final AnchorListItem fiveMinuteRadioButton = this.createTimeSelector(300, "5 " + this.constants.Minutes(), configuredSeconds, resetButton);
        final AnchorListItem tenMinuteRadioButton = this.createTimeSelector(600, "10 " + this.constants.Minutes(), configuredSeconds, resetButton);
        this.menuDropDownMenu.add((Widget)oneMinuteRadioButton);
        this.menuDropDownMenu.add((Widget)fiveMinuteRadioButton);
        this.menuDropDownMenu.add((Widget)tenMinuteRadioButton);
        oneMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                fiveMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        fiveMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        tenMinuteRadioButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                oneMinuteRadioButton.setIcon(null);
                fiveMinuteRadioButton.setIcon(null);
            }
        });
        resetButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RefreshSelectorMenuBuilder.this.supportsRefreshInterval.onUpdateRefreshInterval(false, 0);
                resetButton.setActive(false);
                resetButton.setEnabled(false);
                resetButton.setText(RefreshSelectorMenuBuilder.this.constants.Autorefresh_Disabled());
                oneMinuteRadioButton.setIcon(null);
                fiveMinuteRadioButton.setIcon(null);
                tenMinuteRadioButton.setIcon(null);
            }
        });
        this.menuDropDownMenu.add((Widget)new Divider());
        this.menuDropDownMenu.add((Widget)resetButton);
    }

    public static interface SupportsRefreshInterval {
        public void onUpdateRefreshInterval(boolean var1, int var2);
    }
}

