/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.ext.widgets.table.client.PagedTableHelper;
import org.uberfire.ext.widgets.table.client.UberfireSimplePager;

public class PagedTable<T>
extends SimpleTable<T> {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private int pageSize;
    private AbstractDataProvider<T> dataProvider;
    @UiField
    public UberfireSimplePager pager;
    @UiField
    public ListBox pageSizesSelector;
    protected boolean showPageSizesSelector = false;

    public PagedTable() {
        this(10);
    }

    public PagedTable(int pageSize) {
        this(pageSize, null);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey) {
        this(pageSize, providesKey, null);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences) {
        this(pageSize, providesKey, gridGlobalPreferences, false);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences, boolean showPageSizesSelector) {
        this(pageSize, providesKey, gridGlobalPreferences, showPageSizesSelector, false, false);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences, boolean showPageSizesSelector, boolean showFFButton, boolean showLButton) {
        super(providesKey, gridGlobalPreferences);
        this.showPageSizesSelector = showPageSizesSelector;
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        PagedTableHelper.setSelectedValue((ListBox)this.pageSizesSelector, (String)String.valueOf(pageSize));
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.pageSizesSelector.setVisible(this.showPageSizesSelector);
        this.setShowFastFordwardPagerButton(showFFButton);
        this.setShowLastPagerButton(showLButton);
        this.createPageSizesListBox(5, 20, 5);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void setDataProvider(AbstractDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this);
    }

    public AbstractDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStart() {
        return this.pager.getPageStart();
    }

    public final void loadPageSizePreferences() {
        this.pageSize = this.getPageSizeStored();
        this.dataGrid.setPageSize(this.pageSize);
        this.pager.setPageSize(this.pageSize);
        this.dataGrid.setHeight((this.pageSize == 0 ? 1 : this.pageSize) * 30 + 10 + "px");
    }

    public void createPageSizesListBox(int minPageSize, int maxPageSize, int incPageSize) {
        this.pageSizesSelector.clear();
        PagedTableHelper.setSelectIndexOnPageSizesSelector((int)minPageSize, (int)maxPageSize, (int)incPageSize, (ListBox)this.pageSizesSelector, (int)this.pageSize);
        this.pageSizesSelector.addChangeHandler(event -> {
            this.storePageSizeInGridPreferences(Integer.parseInt(this.pageSizesSelector.getSelectedValue()));
            this.loadPageSizePreferences();
        });
        this.loadPageSizePreferences();
    }

    public void setShowLastPagerButton(boolean showLastPagerButton) {
        this.pager.setShowLastPageButton(showLastPagerButton);
    }

    public void setShowFastFordwardPagerButton(boolean showFastFordwardPagerButton) {
        this.pager.setShowFastFordwardPageButton(showFastFordwardPagerButton);
    }

    private void storePageSizeInGridPreferences(int pageSize) {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.setPageSizePreferences(pageSize);
            super.saveGridPreferences();
        }
        this.pageSize = pageSize;
    }

    private int getPageSizeStored() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            return gridPreferencesStore.getPageSizePreferences();
        }
        return this.pageSize;
    }

    private void resetPageSize() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.resetPageSizePreferences();
            this.storePageSizeInGridPreferences(gridPreferencesStore.getGlobalPreferences().getPageSize());
            this.loadPageSizePreferences();
        }
    }

    static interface Binder
    extends UiBinder<Widget, PagedTable> {
    }
}

