/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ProvidesKey;
import java.util.List;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.tables.ColumnPicker;
import org.uberfire.ext.widgets.table.client.ColumnChangedHandler;
import org.uberfire.ext.widgets.table.client.UberfireSimpleTable;

public class SimpleTable<T>
extends UberfireSimpleTable<T> {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private GridPreferencesStore gridPreferencesStore;
    @Inject
    private Caller<UserPreferencesService> preferencesService;

    public SimpleTable() {
    }

    public SimpleTable(ProvidesKey<T> providesKey) {
        super(providesKey);
    }

    public SimpleTable(ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences) {
        super(providesKey);
        if (gridGlobalPreferences != null) {
            this.gridPreferencesStore = new GridPreferencesStore(gridGlobalPreferences);
        }
    }

    protected void setupColumnPicker() {
        this.columnPicker = new ColumnPicker(this.dataGrid, this.gridPreferencesStore);
        this.columnPicker.addColumnChangedHandler(new ColumnChangedHandler(){

            public void beforeColumnChanged() {
            }

            public void afterColumnChanged() {
                SimpleTable.this.afterColumnChangedHandler();
            }
        });
    }

    protected void afterColumnChangedHandler() {
        if (this.gridPreferencesStore != null && this.preferencesService != null) {
            List<GridColumnPreference> columnsState = this.getColumnPicker().getColumnsState();
            this.gridPreferencesStore.resetGridColumnPreferences();
            for (GridColumnPreference gcp : columnsState) {
                this.gridPreferencesStore.addGridColumnPreference(gcp);
            }
            this.saveGridPreferences();
        }
    }

    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setGridPreferencesStore(GridPreferencesStore gridPreferences) {
        this.gridPreferencesStore = gridPreferences;
        this.getColumnPicker().setGridPreferencesStore(gridPreferences);
    }

    public GridPreferencesStore getGridPreferencesStore() {
        return this.gridPreferencesStore;
    }

    public void saveGridPreferences() {
        if (this.gridPreferencesStore != null && this.preferencesService != null) {
            this.gridPreferencesStore.setPreferenceKey(this.gridPreferencesStore.getGlobalPreferences().getKey());
            this.gridPreferencesStore.setType(UserPreferencesType.GRIDPREFERENCES);
            ((UserPreferencesService)this.preferencesService.call(response -> {})).saveUserPreferences((UserPreference)this.gridPreferencesStore);
        }
    }

    public void storeColumnToPreferences() {
        List<GridColumnPreference> columnsState = this.getColumnPicker().getColumnsState();
        this.gridPreferencesStore.resetGridColumnPreferences();
        for (GridColumnPreference gcp : columnsState) {
            this.gridPreferencesStore.addGridColumnPreference(gcp);
        }
        this.saveGridPreferences();
    }

    protected ColumnPicker getColumnPicker() {
        return (ColumnPicker)this.columnPicker;
    }

    static interface Binder
    extends UiBinder<Widget, SimpleTable> {
    }
}

