/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.breadcrumbs;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.workbench.docks.UberfireDockContainerReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocksContainer;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.BreadcrumbsPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireBreadcrumbsTest {
    @Mock
    private UberfireDocksContainer uberfireDocksContainer;
    @Mock
    private ManagedInstance<BreadcrumbsPresenter> breadcrumbsPresenters;
    @Mock
    private PlaceManager placeManager;
    private UberfireBreadcrumbs uberfireBreadcrumbs;
    private UberfireBreadcrumbs.View view;

    @Before
    public void setup() {
        Mockito.when((Object)this.breadcrumbsPresenters.get()).thenReturn(Mockito.mock(BreadcrumbsPresenter.class)).thenReturn(Mockito.mock(BreadcrumbsPresenter.class)).thenReturn(Mockito.mock(BreadcrumbsPresenter.class));
        this.view = (UberfireBreadcrumbs.View)Mockito.mock(UberfireBreadcrumbs.View.class);
        this.uberfireBreadcrumbs = new UberfireBreadcrumbs(this.uberfireDocksContainer, this.breadcrumbsPresenters, this.placeManager, this.view){};
    }

    @Test
    public void setupTest() {
        this.uberfireBreadcrumbs.setup(new UberfireDockContainerReadyEvent());
        Assert.assertNotNull((Object)this.uberfireBreadcrumbs);
        ((UberfireDocksContainer)Mockito.verify((Object)this.uberfireDocksContainer)).addBreadcrumbs((IsElement)Matchers.any(IsElement.class), Double.valueOf(Mockito.eq((double)35.0)));
    }

    @Test
    public void addToolbar() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addToolbar("myperspective", (Element)Mockito.mock(Element.class));
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
    }

    @Test
    public void addBreadCrumbs() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", new DefaultPlaceRequest("screen"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label2", new DefaultPlaceRequest("screen2"), Optional.empty());
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective2", "label4", new DefaultPlaceRequest("screen4"));
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        Assert.assertEquals((long)2L, (long)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.size());
        Assert.assertEquals((long)2L, (long)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).size());
    }

    @Test
    public void clearBreadCrumbs() {
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addToolbar("myperspective", (Element)Mockito.mock(Element.class));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", new DefaultPlaceRequest("screen"));
        Assert.assertFalse((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.clearBreadCrumbsAndToolBars("myperspective");
        Assert.assertTrue((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
    }

    @Test
    public void removeDeepLevelBreadcrumbsTest() {
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", new DefaultPlaceRequest("screen"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label2", new DefaultPlaceRequest("screen2"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label3", new DefaultPlaceRequest("screen3"));
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        this.uberfireBreadcrumbs.removeDeepLevelBreadcrumbs("myperspective", (BreadcrumbsPresenter)breadcrumbs.get(0));
        Assert.assertEquals((long)1L, (long)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).size());
    }

    @Test
    public void generateBreadCrumbSelectCommandTest() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("screen");
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", placeRequest);
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        BreadcrumbsPresenter breadcrumb = (BreadcrumbsPresenter)breadcrumbs.get(0);
        this.uberfireBreadcrumbs.generateBreadCrumbSelectCommand("myperspective", breadcrumb, placeRequest, Optional.empty()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.eq((Object)placeRequest), (HasWidgets)Matchers.any(HasWidgets.class));
    }

    @Test
    public void generateBreadCrumbSelectCommandWithTargetPanelTest() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("screen");
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", placeRequest);
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        BreadcrumbsPresenter breadcrumb = (BreadcrumbsPresenter)breadcrumbs.get(0);
        this.uberfireBreadcrumbs.generateBreadCrumbSelectCommand("myperspective", breadcrumb, placeRequest, Optional.of(Mockito.mock(HasWidgets.class))).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)Mockito.eq((Object)placeRequest), (HasWidgets)Matchers.any(HasWidgets.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)placeRequest);
    }

    @Test
    public void getViewShouldAddInnerBreadCrumbsTest() {
        List<BreadcrumbsPresenter> breadcrumbs = Arrays.asList((BreadcrumbsPresenter)Mockito.mock(BreadcrumbsPresenter.class), (BreadcrumbsPresenter)Mockito.mock(BreadcrumbsPresenter.class));
        this.uberfireBreadcrumbs.breadcrumbsPerPerspective.put("myperspective", breadcrumbs);
        this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.put("myperspective", Mockito.mock(Element.class));
        this.uberfireBreadcrumbs.getView();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view)).clear();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addBreadcrumb((UberElement)Matchers.any(UberElement.class));
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.getView();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addBreadcrumb((UberElement)Matchers.any(UberElement.class));
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBreadcrumbToolbar((Element)Matchers.any(Element.class));
    }
}

