/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.datepicker.client.ui.base.constants.DatePickerLanguage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.widgets.common.client.common.DatePickerFormatUtilities;

@RunWith(value=GwtMockitoTestRunner.class)
public class DatePickerTest {
    @Mock
    public org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker datePickerMock;
    public DatePicker datePicker;
    @Mock
    TextBox textBox;

    @Before
    public void setup() {
        Mockito.when((Object)this.datePickerMock.getTextBox()).thenReturn((Object)this.textBox);
    }

    @Test
    public void testSetFormat() {
        this.datePicker = new DatePicker(this.datePickerMock);
        String gwtDateFormat = "dd-MMM-yyyy";
        DateTimeFormat gwtDateTimeFormat = DateTimeFormat.getFormat((String)gwtDateFormat);
        this.datePicker.setLocaleName("en");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.EN);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setFormat(DatePickerFormatUtilities.convertToBS3DateFormat((String)gwtDateFormat));
        Date now = new Date();
        now = gwtDateTimeFormat.parse(gwtDateTimeFormat.format(now));
        this.datePicker.setValue(now);
        ((TextBox)Mockito.verify((Object)this.textBox)).setValue((Object)gwtDateTimeFormat.format(now));
        Mockito.when((Object)this.textBox.getValue()).thenReturn((Object)gwtDateTimeFormat.format(now));
        Assert.assertEquals((Object)now, (Object)this.datePicker.getValue());
    }

    @Test
    public void testSetDatePickerLang() {
        this.datePicker = new DatePicker(this.datePickerMock);
        String gwtDateFormat = "dd-MMM-yyyy";
        this.datePicker.setLocaleName("es");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.ES);
        this.datePicker.setLocaleName("fr");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.FR);
        this.datePicker.setLocaleName("ja");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.JA);
        this.datePicker.setLocaleName("pt_BR");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.PT_BR);
        this.datePicker.setLocaleName("zh_CN");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.ZH_CN);
        this.datePicker.setLocaleName("de");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.DE);
        this.datePicker.setLocaleName("zh_TW");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.ZH_TW);
        this.datePicker.setLocaleName("ru");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.RU);
        this.datePicker.setLocaleName("en");
        this.datePicker.setFormat(gwtDateFormat);
        ((org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker)Mockito.verify((Object)this.datePickerMock)).setLanguage(DatePickerLanguage.EN);
    }

    @Test
    public void testGetLocaleName() {
        this.datePicker = new DatePicker(this.datePickerMock);
        this.datePicker.setLocaleName("");
        Assert.assertEquals((Object)"", (Object)this.datePicker.getLocaleName());
        this.datePicker.setLocaleName(null);
        Assert.assertEquals((Object)"", (Object)this.datePicker.getLocaleName());
        this.datePicker.setLocaleName("default");
        Assert.assertEquals((Object)"", (Object)this.datePicker.getLocaleName());
        String currentLocale = "testValue";
        this.datePicker.setLocaleName(currentLocale);
        Assert.assertEquals((Object)currentLocale, (Object)this.datePicker.getLocaleName());
    }
}

