/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Element;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class FilterPagedTableTest {
    FilterPagedTable filterPagedTable;
    @GwtMock
    Button button;
    @GwtMock
    protected MultiGridPreferencesStore multiGridPreferencesStoreMock;
    @GwtMock
    protected PagedTable pagedTableMock;
    @GwtMock
    protected YesNoCancelPopup yesNoCancelPopupMock;
    @GwtMock
    NavTabs navTabs;
    ClickHandler clickHandler;

    @Test
    public void testRemoveTab() throws Exception {
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)element.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.button.getElement()).thenReturn((Object)element);
        Mockito.when((Object)this.button.addClickHandler((ClickHandler)Mockito.any(ClickHandler.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                FilterPagedTableTest.this.clickHandler = (ClickHandler)aInvocation.getArguments()[0];
                return null;
            }
        });
        YesNoCancelPopup yesNoCancelPopup = (YesNoCancelPopup)Mockito.mock(YesNoCancelPopup.class);
        this.filterPagedTable = (FilterPagedTable)Mockito.spy((Object)new FilterPagedTable((MultiGridPreferencesStore)Mockito.mock(MultiGridPreferencesStore.class)));
        ((FilterPagedTable)Mockito.doReturn((Object)yesNoCancelPopup).when((Object)this.filterPagedTable)).getYesNoCancelPopup(Mockito.anyString(), Mockito.anyString());
        this.filterPagedTable.makeWidget();
        this.filterPagedTable.addTab((PagedTable)Mockito.mock(PagedTable.class), "", (Command)Mockito.mock(Command.class));
        this.clickHandler.onClick(new ClickEvent(){});
        ((YesNoCancelPopup)Mockito.verify((Object)yesNoCancelPopup)).show();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.never())).removeTab(Mockito.anyInt());
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.never())).removeTab(Mockito.anyString());
    }

    @Test
    public void testScapeHtmlCodeInDescriptionRemoveTab() throws Exception {
        String key = "test";
        String header = "*<h1>test</h1>*";
        String title = "*<h1>test</h1>*";
        Element element = (Element)Mockito.mock(Element.class);
        Mockito.when((Object)element.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.button.getElement()).thenReturn((Object)element);
        Mockito.when((Object)this.button.addClickHandler((ClickHandler)Mockito.any(ClickHandler.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                FilterPagedTableTest.this.clickHandler = (ClickHandler)aInvocation.getArguments()[0];
                return null;
            }
        });
        this.filterPagedTable = (FilterPagedTable)Mockito.spy((Object)new FilterPagedTable(this.multiGridPreferencesStoreMock));
        ((FilterPagedTable)Mockito.doReturn((Object)this.yesNoCancelPopupMock).when((Object)this.filterPagedTable)).getYesNoCancelPopup((String)Mockito.eq((Object)SafeHtmlUtils.htmlEscape((String)header)), Mockito.anyString());
        this.filterPagedTable.makeWidget();
        Mockito.when((Object)this.multiGridPreferencesStoreMock.getGridSettingParam((String)Mockito.eq((Object)key), (String)Mockito.eq((Object)NewTabFilterPopup.FILTER_TAB_NAME_PARAM))).thenReturn((Object)header);
        Mockito.when((Object)this.multiGridPreferencesStoreMock.getGridSettingParam((String)Mockito.eq((Object)key), (String)Mockito.eq((Object)NewTabFilterPopup.FILTER_TAB_DESC_PARAM))).thenReturn((Object)title);
        this.filterPagedTable.addTab(this.pagedTableMock, key, (Command)Mockito.mock(Command.class));
        this.clickHandler.onClick(new ClickEvent(){});
        ((PagedTable)Mockito.verify((Object)this.pagedTableMock)).addTableTitle((String)Mockito.eq((Object)SafeHtmlUtils.htmlEscape((String)title)));
        ((YesNoCancelPopup)Mockito.verify((Object)this.yesNoCancelPopupMock)).show();
    }
}

