/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.html.Text;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.DataGrid;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Image.class, Label.class, Text.class})
public class PagedTableTest {
    @GwtMock
    AsyncDataProvider dataProvider;
    @GwtMock
    Select select;

    @Test
    public void testSetDataProvider() throws Exception {
        PagedTable pagedTable = new PagedTable();
        pagedTable.setDataProvider((AbstractDataProvider)this.dataProvider);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProvider)).addDataDisplay((HasData)pagedTable);
    }

    @Test
    public void testDataGridHeight() throws Exception {
        int PAGE_SIZE = 10;
        int ROWS = 2;
        int EXPECTED_HEIGHT_PX = 20;
        PagedTable pagedTable = new PagedTable(10, null, null, false, false, false);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        Mockito.when((Object)pagedTable.dataGrid.getRowCount()).thenReturn((Object)2);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setHeight(Mockito.anyString());
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setHeight((String)Mockito.eq((Object)"20px"));
    }

    @Test
    public void testDataGridHeightWithMoreItemsThanPaging() throws Exception {
        int PAGE_SIZE = 10;
        int ROWS = 12;
        int EXPECTED_HEIGHT_PX = 20;
        PagedTable pagedTable = new PagedTable(10, null, null, false, false, false);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        Mockito.when((Object)pagedTable.dataGrid.getRowCount()).thenReturn((Object)12);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setHeight(Mockito.anyString());
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setHeight((String)Mockito.eq((Object)"20px"));
    }

    @Test
    public void testLoadPageSizePreferencesResetsPageStart() throws Exception {
        int PAGE_SIZE = 10;
        PagedTable pagedTable = new PagedTable(10);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setPageStart(0);
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setPageStart(0);
    }

    @Test
    public void testPageSizeSelectStartValue() throws Exception {
        int size = 10;
        new PagedTable(10);
        ((Select)Mockito.verify((Object)this.select)).setValue((Object)String.valueOf(10));
        ((Select)Mockito.verify((Object)this.select)).addValueChangeHandler((ValueChangeHandler)Mockito.any());
    }

    @Test
    public void testDefaultPageSizeValue() throws Exception {
        new PagedTable();
        ((Select)Mockito.verify((Object)this.select)).setValue((Object)String.valueOf(10));
        ((Select)Mockito.verify((Object)this.select)).addValueChangeHandler((ValueChangeHandler)Mockito.any());
    }
}

