/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.common.collect.Lists;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.common.client.tables.ColumnPicker;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnPickerTest {
    @InjectMocks
    ColumnPicker columnPicker;
    @GwtMock
    DataGrid dataGrid;
    @GwtMock
    Button toggleButton;
    @GwtMock
    PopupPanel popup;
    ClickHandler clickHandler;

    @Before
    public void setUp() throws Exception {
        final ArrayList columns = new ArrayList();
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                columns.add((Column)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.dataGrid)).addColumn((Column)Mockito.any(Column.class), (Header)Mockito.any(Header.class));
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocationOnMock) throws Throwable {
                return columns.size();
            }
        }).when((Object)this.dataGrid)).getColumnCount();
        ((DataGrid)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                columns.remove(0);
                return null;
            }
        }).when((Object)this.dataGrid)).removeColumn(0);
        Mockito.when((Object)this.toggleButton.addClickHandler((ClickHandler)Mockito.any(ClickHandler.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                ColumnPickerTest.this.clickHandler = (ClickHandler)aInvocation.getArguments()[0];
                return null;
            }
        });
    }

    @Test
    public void testAddRemoveColumn() {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getDataStoreName()).thenReturn((Object)"id");
        ColumnMeta meta = new ColumnMeta(column, "caption");
        meta.setHeader((Header)new TextHeader("header"));
        this.columnPicker.addColumn(meta);
        Assert.assertTrue((boolean)this.columnPicker.getColumnMetaList().contains(meta));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column, meta.getHeader());
        Assert.assertEquals((long)1L, (long)this.dataGrid.getColumnCount());
        this.columnPicker.removeColumn(meta);
        Assert.assertFalse((boolean)this.columnPicker.getColumnMetaList().contains(meta));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).removeColumn(0);
        Assert.assertEquals((long)0L, (long)this.dataGrid.getColumnCount());
    }

    @Test
    public void testSortColumn() {
        Column column1 = (Column)Mockito.mock(Column.class);
        ColumnMeta meta1 = new ColumnMeta(column1, "caption1", true, 1);
        meta1.setHeader((Header)new TextHeader("header1"));
        Column column0 = (Column)Mockito.mock(Column.class);
        ColumnMeta meta0 = new ColumnMeta(column0, "caption0", true, 0);
        meta0.setHeader((Header)new TextHeader("header0"));
        this.columnPicker.addColumns(Arrays.asList(meta1, meta0));
        Assert.assertEquals((long)2L, (long)this.columnPicker.getColumnMetaList().size());
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column0, meta0.getHeader());
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).addColumn(column1, meta1.getHeader());
        Assert.assertEquals((long)2L, (long)this.dataGrid.getColumnCount());
    }

    @Test
    public void testColumnPreference() {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getDataStoreName()).thenReturn((Object)"id");
        ColumnMeta meta = new ColumnMeta(column, "caption");
        meta.setHeader((Header)new TextHeader("header"));
        this.columnPicker.addColumn(meta);
        List columnsState = this.columnPicker.getColumnsState();
        Assert.assertEquals((long)1L, (long)columnsState.size());
        GridColumnPreference preference = (GridColumnPreference)columnsState.get(0);
        Assert.assertEquals((Object)preference.getName(), (Object)column.getDataStoreName());
        Assert.assertEquals((long)0L, (long)preference.getPosition().intValue());
    }

    @Test
    public void testToggleButton() {
        this.columnPicker.createToggleButton();
        this.clickHandler.onClick(new ClickEvent(){});
        ((PopupPanel)Mockito.verify((Object)this.popup)).show();
        Mockito.when((Object)this.toggleButton.isActive()).thenReturn((Object)true);
        this.clickHandler.onClick(new ClickEvent(){});
        ((PopupPanel)Mockito.verify((Object)this.popup)).hide(false);
    }

    @Test
    public void testAdjustColumnWidths() {
        Column column1 = this.createColumn("col1", "col1");
        ColumnMeta meta1 = new ColumnMeta(column1, "caption1", true, 1);
        meta1.setHeader((Header)new TextHeader("header1"));
        Column column2 = this.createColumn("col2", "col2");
        ColumnMeta meta2 = new ColumnMeta(column2, "caption2", true, 0);
        meta2.setHeader((Header)new TextHeader("header2"));
        Column column3 = this.createColumn("col3", "col3");
        ColumnMeta meta3 = new ColumnMeta(column3, "caption3", true, 0);
        meta3.setHeader((Header)new TextHeader("header3"));
        Mockito.when((Object)this.dataGrid.getColumnWidth(column1)).thenReturn((Object)"35px");
        Mockito.when((Object)this.dataGrid.getColumnWidth(column2)).thenReturn(null);
        Mockito.when((Object)this.dataGrid.getColumnWidth(column3)).thenReturn(null);
        ArrayList<ColumnMeta> columnMetasList = new ArrayList<ColumnMeta>();
        columnMetasList.add(meta1);
        columnMetasList.add(meta2);
        columnMetasList.add(meta3);
        this.columnPicker.addColumns(columnMetasList);
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth(column1, "35px");
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth(column2, 50.0, Style.Unit.PCT);
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth(column3, 50.0, Style.Unit.PCT);
    }

    private Column createColumn(final String value, String dataStoreName) {
        Column<String, String> testColumn = new Column<String, String>((Cell)new TextCell()){

            public String getValue(String object) {
                return value;
            }
        };
        testColumn.setSortable(true);
        testColumn.setDataStoreName(dataStoreName);
        return testColumn;
    }

    @Test
    public void testSetColumnWidth() {
        Column column1 = this.createColumn("col1", "col1");
        ColumnMeta meta1 = new ColumnMeta(column1, "caption1", true, 1);
        Column column2 = this.createColumn("col2", "col2");
        ColumnMeta meta2 = new ColumnMeta(column2, "caption2", true, 0);
        Mockito.when((Object)this.dataGrid.getColumnWidth(column1)).thenReturn((Object)"38.0px");
        this.columnPicker.addColumns((List)Lists.newArrayList((Object[])new ColumnMeta[]{meta1, meta2}));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth((Column)Mockito.eq((Object)column1), (String)Mockito.eq((Object)"38px"));
    }

    @Test
    public void testAddColumnsIncrementally() {
        Column column1 = this.createColumn("col1", "col1");
        ColumnMeta meta1 = new ColumnMeta(column1, "caption1", true, 1);
        Column column2 = this.createColumn("col2", "col2");
        ColumnMeta meta2 = new ColumnMeta(column2, "caption2", true, 0);
        Mockito.when((Object)this.dataGrid.getColumn(0)).thenReturn((Object)column1);
        Mockito.when((Object)this.dataGrid.getColumn(1)).thenReturn((Object)column2);
        Mockito.when((Object)this.dataGrid.getColumnWidth(column1)).thenReturn((Object)"100px");
        Mockito.when((Object)this.dataGrid.getColumnWidth(column2)).thenReturn((Object)"90%");
        this.columnPicker.addColumns(Collections.singletonList(meta1));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth((Column)Mockito.eq((Object)column1), Mockito.eq((double)100.0), (Style.Unit)Mockito.eq((Object)Style.Unit.PCT));
        this.columnPicker.addColumns(Collections.singletonList(meta2));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth((Column)Mockito.eq((Object)column1), (String)Mockito.eq((Object)"100px"));
        ((DataGrid)Mockito.verify((Object)this.dataGrid)).setColumnWidth((Column)Mockito.eq((Object)column2), Mockito.eq((double)100.0), (Style.Unit)Mockito.eq((Object)Style.Unit.PCT));
    }
}

