/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchCallback;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDownView;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchResults;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class LiveSearchDropDownTest {
    @Mock
    LiveSearchDropDownView view;
    @Mock
    LiveSearchCallback searchCallback;
    @Spy
    LiveSearchService searchService = new LiveSearchService(){

        public void search(String pattern, int max, LiveSearchCallback callback) {
            LiveSearchResults results = new LiveSearchResults();
            switch (pattern) {
                case "a": {
                    results.add("1", "a");
                    callback.afterSearch(results);
                    break;
                }
                case "b": {
                    results.add("1", "a");
                    results.add("2", "b");
                    results.add("3", "c");
                    callback.afterSearch(results);
                    break;
                }
                default: {
                    callback.afterSearch(results);
                }
            }
        }
    };
    @Mock
    Command onChangeCommand;
    @Mock
    ClickEvent clickEvent;
    LiveSearchDropDown presenter;

    @Before
    public void setUp() {
        this.presenter = (LiveSearchDropDown)Mockito.spy((Object)new LiveSearchDropDown((LiveSearchDropDown.View)this.view));
        this.presenter.setOnChange(this.onChangeCommand);
        this.presenter.setSearchService(this.searchService);
        ((LiveSearchDropDownView)Mockito.doAnswer(invocationOnMock -> {
            ClickEvent event = (ClickEvent)invocationOnMock.getArguments()[0];
            event.stopPropagation();
            return null;
        }).when((Object)this.view)).onSearchClick((ClickEvent)Mockito.any());
    }

    @Test
    public void testInit() {
        this.presenter.setWidth(200);
        this.presenter.setMaxItems(10);
        this.presenter.setSearchHint("a");
        this.presenter.setSelectorHint("b");
        Assert.assertEquals((long)this.presenter.getMaxItems(), (long)10L);
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).setWidth(200);
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).setSearchHint("a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).setDropDownText("b");
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.getLastSearch());
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).clearSearch();
    }

    @Test
    public void testSearch() {
        this.presenter.search("a");
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).addItem("1", "a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify((Object)this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testEmptySearch() {
        this.presenter.setSearchHint("s");
        this.presenter.setNotFoundMessage("n");
        this.presenter.setMaxItems(15);
        this.presenter.search("");
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).searchInProgress("s");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).noItems("n");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify((Object)this.searchService)).search((String)Mockito.eq((Object)""), Mockito.eq((int)15), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testRepeatedSearch() {
        this.presenter.search("a");
        this.presenter.search("a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).addItem("1", "a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify((Object)this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testSearchCache() {
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        Assert.assertTrue((boolean)this.presenter.isSearchCacheEnabled());
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).searchInProgress(Mockito.anyString());
        ((LiveSearchService)Mockito.verify((Object)this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchService)Mockito.verify((Object)this.searchService)).search((String)Mockito.eq((Object)""), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).searchFinished();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)6))).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addItem("1", "a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).noItems(Mockito.anyString());
    }

    @Test
    public void testSearchCacheDisabled() {
        this.presenter.setSearchCacheEnabled(false);
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        Assert.assertFalse((boolean)this.presenter.isSearchCacheEnabled());
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)6))).searchInProgress(Mockito.anyString());
        ((LiveSearchService)Mockito.verify((Object)this.searchService, (VerificationMode)Mockito.times((int)3))).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchService)Mockito.verify((Object)this.searchService, (VerificationMode)Mockito.times((int)3))).search((String)Mockito.eq((Object)""), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)6))).searchFinished();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)6))).clearItems();
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).addItem("1", "a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).noItems(Mockito.anyString());
    }

    @Test
    public void testItemsOrdered() {
        this.presenter.search("b");
        ArgumentCaptor resultsCaptor = ArgumentCaptor.forClass(LiveSearchResults.class);
        ((LiveSearchDropDown)Mockito.verify((Object)this.presenter)).showResults((LiveSearchResults)resultsCaptor.capture());
        LiveSearchResults results = (LiveSearchResults)resultsCaptor.getValue();
        Assert.assertEquals((long)results.size(), (long)3L);
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getValue(), (Object)"a");
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getValue(), (Object)"b");
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(2)).getValue(), (Object)"c");
    }

    @Test
    public void testItemSelected() {
        this.presenter.onItemSelected("1", "a");
        Assert.assertEquals((Object)this.presenter.getSelectedKey(), (Object)"1");
        Assert.assertEquals((Object)this.presenter.getSelectedValue(), (Object)"a");
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).setDropDownText("a");
        ((Command)Mockito.verify((Object)this.onChangeCommand)).execute();
    }

    @Test
    public void testOnClickSearchInput() {
        this.view.onSearchClick(this.clickEvent);
        ((ClickEvent)Mockito.verify((Object)this.clickEvent)).stopPropagation();
    }
}

