/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectorItem;
import org.uberfire.ext.widgets.common.client.dropdown.SingleLiveSearchSelectionHandler;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class SingleLiveSearchSelectionHandlerTest {
    private String SELECTED_ITEM_TEXT = "selectedItem";
    @Spy
    private SingleLiveSearchSelectionHandler handler = new SingleLiveSearchSelectionHandler();
    @Mock
    private Command callback;

    @Before
    public void init() {
        this.handler.setLiveSearchSelectionCallback(this.callback);
    }

    @Test
    public void testRegisterItemWithoutSelectedValue() {
        LiveSearchSelectorItem item = this.createItem("any");
        this.handler.registerItem(item);
        ((LiveSearchSelectorItem)Mockito.verify((Object)item, (VerificationMode)Mockito.never())).select();
        ((LiveSearchSelectorItem)Mockito.verify((Object)item, (VerificationMode)Mockito.times((int)1))).setSelectionCallback((Command)Matchers.any());
        this.checkHandlerSelectedValue(null);
    }

    @Test
    public void testRegisterIItemWithSelectedValue() {
        LiveSearchSelectorItem selectedItem = this.doTestSelectItem();
        LiveSearchSelectorItem secondItem = this.createItem(this.SELECTED_ITEM_TEXT);
        this.handler.registerItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)selectedItem, (VerificationMode)Mockito.atLeast((int)1))).getKey();
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).getKey();
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).select();
    }

    @Test
    public void testSelectItem() {
        this.doTestSelectItem();
    }

    protected LiveSearchSelectorItem doTestSelectItem() {
        LiveSearchSelectorItem item = this.createItem(this.SELECTED_ITEM_TEXT);
        this.handler.registerItem(item);
        this.handler.selectItem(item);
        ((LiveSearchSelectorItem)Mockito.verify((Object)item)).select();
        this.checkHandlerSelectedValue(this.SELECTED_ITEM_TEXT);
        ((Command)Mockito.verify((Object)this.callback)).execute();
        return item;
    }

    @Test
    public void testSelectSecondItem() {
        LiveSearchSelectorItem firstItem = this.doTestSelectItem();
        String secondSelected = this.SELECTED_ITEM_TEXT + "2";
        LiveSearchSelectorItem secondItem = this.createItem(secondSelected);
        this.handler.registerItem(secondItem);
        this.handler.selectItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).select();
        ((LiveSearchSelectorItem)Mockito.verify((Object)firstItem)).reset();
        this.checkHandlerSelectedValue(secondSelected);
    }

    @Test
    public void testSelectKeyWithoutSelectedValue() {
        LiveSearchSelectorItem firstItem = this.createItem("a");
        this.handler.registerItem(firstItem);
        LiveSearchSelectorItem secondItem = this.createItem("b");
        this.handler.registerItem(secondItem);
        LiveSearchSelectorItem thirdItem = this.createItem(this.SELECTED_ITEM_TEXT);
        this.handler.registerItem(thirdItem);
        this.handler.selectKey((Object)"a");
        ((SingleLiveSearchSelectionHandler)Mockito.verify((Object)this.handler)).selectItem(firstItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)firstItem)).select();
        this.checkHandlerSelectedValue("a");
        this.handler.selectKey((Object)"b");
        ((SingleLiveSearchSelectionHandler)Mockito.verify((Object)this.handler)).selectItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).select();
        ((LiveSearchSelectorItem)Mockito.verify((Object)firstItem)).reset();
        this.checkHandlerSelectedValue("b");
        this.handler.selectKey((Object)this.SELECTED_ITEM_TEXT);
        ((SingleLiveSearchSelectionHandler)Mockito.verify((Object)this.handler)).selectItem(thirdItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)thirdItem)).select();
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).reset();
        this.checkHandlerSelectedValue(this.SELECTED_ITEM_TEXT);
    }

    @Test
    public void testClearSelection() {
        LiveSearchSelectorItem item = this.doTestSelectItem();
        this.handler.clearSelection();
        ((LiveSearchSelectorItem)Mockito.verify((Object)item)).reset();
        this.checkHandlerSelectedValue(null);
    }

    private LiveSearchSelectorItem createItem(String value) {
        LiveSearchSelectorItem item = (LiveSearchSelectorItem)Mockito.mock(LiveSearchSelectorItem.class);
        Mockito.when((Object)item.getKey()).thenReturn((Object)value);
        Mockito.when((Object)item.getValue()).thenReturn((Object)value);
        return item;
    }

    private void checkHandlerSelectedValue(String value) {
        Assert.assertEquals((Object)value, (Object)this.handler.getSelectedKey());
        Assert.assertEquals((Object)value, (Object)this.handler.getSelectedValue());
        Assert.assertEquals((Object)value, (Object)this.handler.getDropDownMenuHeader());
    }
}

