/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchCallback;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDownView;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchResults;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectorItem;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.SingleLiveSearchSelectionHandler;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class LiveSearchDropDownTest {
    @Mock
    LiveSearchDropDownView<String> view;
    @Mock
    LiveSearchCallback<String> searchCallback;
    @Spy
    LiveSearchService<String> searchService = new LiveSearchService<String>(){

        public void search(String pattern, int maxResults, LiveSearchCallback<String> callback) {
            LiveSearchResults results = new LiveSearchResults();
            switch (pattern) {
                case "a": {
                    results.add("1", "a");
                    callback.afterSearch(results);
                    break;
                }
                case "b": {
                    results.add("1", "a");
                    results.add("2", "b");
                    results.add("3", "c");
                    callback.afterSearch(results);
                    break;
                }
                default: {
                    callback.afterSearch(results);
                }
            }
        }
    };
    @Spy
    SingleLiveSearchSelectionHandler<String> selectionHandler = new SingleLiveSearchSelectionHandler();
    @Mock
    Command onChangeCommand;
    @Mock
    ClickEvent clickEvent;
    LiveSearchDropDown<String> presenter;
    @Mock
    ManagedInstance<LiveSearchSelectorItem<String>> selectorItems;

    @Before
    public void setUp() {
        Mockito.when((Object)this.selectorItems.get()).thenAnswer((Answer)new Answer<LiveSearchSelectorItem<String>>(){

            public LiveSearchSelectorItem<String> answer(InvocationOnMock invocationOnMock) throws Throwable {
                LiveSearchSelectorItem result = (LiveSearchSelectorItem)Mockito.mock(LiveSearchSelectorItem.class);
                ((LiveSearchSelectorItem)Mockito.doAnswer(invocationOnMock1 -> {
                    String key = (String)invocationOnMock1.getArguments()[0];
                    String value = (String)invocationOnMock1.getArguments()[1];
                    Mockito.when((Object)result.getKey()).thenReturn((Object)key);
                    Mockito.when((Object)result.getValue()).thenReturn((Object)value);
                    return null;
                }).when((Object)result)).init(Mockito.any(), (String)Mockito.any());
                return result;
            }
        });
        this.presenter = (LiveSearchDropDown)Mockito.spy((Object)new LiveSearchDropDown(this.view, this.selectorItems));
        this.presenter.setOnChange(this.onChangeCommand);
        this.presenter.init(this.searchService, this.selectionHandler);
        ((LiveSearchDropDownView)Mockito.doAnswer(invocationOnMock -> {
            ClickEvent event = (ClickEvent)invocationOnMock.getArguments()[0];
            event.stopPropagation();
            return null;
        }).when(this.view)).onSearchClick((ClickEvent)Mockito.any());
    }

    @Test
    public void testInit() {
        this.presenter.setWidth(200);
        this.presenter.setMaxItems(10);
        this.presenter.setSearchHint("a");
        this.presenter.setSelectorHint("b");
        Assert.assertEquals((long)this.presenter.getMaxItems(), (long)10L);
        ((LiveSearchDropDownView)Mockito.verify(this.view)).setWidth(200);
        ((LiveSearchDropDownView)Mockito.verify(this.view)).setSearchHint("a");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).setDropDownText("b");
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.getLastSearch());
        ((LiveSearchDropDownView)Mockito.verify(this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view)).clearSearch();
    }

    @Test
    public void testSearch() {
        this.presenter.search("a");
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"a");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view)).addItem((LiveSearchSelectorItem)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify(this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testEmptySearch() {
        this.presenter.setSearchHint("s");
        this.presenter.setNotFoundMessage("n");
        this.presenter.setMaxItems(15);
        this.presenter.search("");
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).searchInProgress("s");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view)).noItems("n");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify(this.searchService)).search((String)Mockito.eq((Object)""), Mockito.eq((int)15), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testRepeatedSearch() {
        this.presenter.search("a");
        this.presenter.search("a");
        ((LiveSearchDropDownView)Mockito.verify(this.view)).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view)).addItem((LiveSearchSelectorItem)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view)).searchFinished();
        ((LiveSearchService)Mockito.verify(this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
    }

    @Test
    public void testSearchCache() {
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        Assert.assertTrue((boolean)this.presenter.isSearchCacheEnabled());
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)2))).searchInProgress(Mockito.anyString());
        ((LiveSearchService)Mockito.verify(this.searchService)).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchService)Mockito.verify(this.searchService)).search((String)Mockito.eq((Object)""), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)2))).searchFinished();
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)6))).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)3))).addItem((LiveSearchSelectorItem)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)3))).noItems(Mockito.anyString());
    }

    @Test
    public void testSearchCacheDisabled() {
        this.presenter.setSearchCacheEnabled(false);
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        this.presenter.search("a");
        this.presenter.search("");
        Assert.assertFalse((boolean)this.presenter.isSearchCacheEnabled());
        Assert.assertEquals((Object)this.presenter.getLastSearch(), (Object)"");
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)6))).searchInProgress(Mockito.anyString());
        ((LiveSearchService)Mockito.verify(this.searchService, (VerificationMode)Mockito.times((int)3))).search((String)Mockito.eq((Object)"a"), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchService)Mockito.verify(this.searchService, (VerificationMode)Mockito.times((int)3))).search((String)Mockito.eq((Object)""), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)6))).searchFinished();
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)6))).clearItems();
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)3))).addItem((LiveSearchSelectorItem)Mockito.any());
        ((LiveSearchDropDownView)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)3))).noItems(Mockito.anyString());
    }

    @Test
    public void testItemsOrdered() {
        this.presenter.search("b");
        ArgumentCaptor resultsCaptor = ArgumentCaptor.forClass(LiveSearchResults.class);
        ((LiveSearchDropDown)Mockito.verify(this.presenter)).showResults((LiveSearchResults)resultsCaptor.capture());
        LiveSearchResults results = (LiveSearchResults)resultsCaptor.getValue();
        Assert.assertEquals((long)results.size(), (long)3L);
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(0)).getValue(), (Object)"a");
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(1)).getValue(), (Object)"b");
        Assert.assertEquals((Object)((LiveSearchEntry)results.get(2)).getValue(), (Object)"c");
    }

    @Test
    public void testItemSelected() {
        ((LiveSearchService)Mockito.doAnswer(invocationOnMock -> {
            LiveSearchResults results = new LiveSearchResults();
            results.add("1", "a");
            results.add("2", "b");
            results.add("3", "c");
            LiveSearchCallback callback = (LiveSearchCallback)invocationOnMock.getArguments()[2];
            callback.afterSearch(results);
            return null;
        }).when(this.searchService)).search(Mockito.anyString(), Mockito.anyInt(), (LiveSearchCallback)Mockito.any());
        this.presenter.setSelectedItem((Object)"1");
        Assert.assertEquals((Object)"1", (Object)this.selectionHandler.getSelectedKey());
        ((LiveSearchDropDownView)Mockito.verify(this.view)).setDropDownText("a");
        ((Command)Mockito.verify((Object)this.onChangeCommand, (VerificationMode)Mockito.never())).execute();
    }

    @Test
    public void testOnClickSearchInput() {
        this.view.onSearchClick(this.clickEvent);
        ((ClickEvent)Mockito.verify((Object)this.clickEvent)).stopPropagation();
    }
}

