/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.DataGrid;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Image.class, Label.class, Text.class})
public class PagedTableTest {
    @GwtMock
    AsyncDataProvider dataProvider;

    @Test
    public void testSetDataProvider() throws Exception {
        PagedTable pagedTable = new PagedTable(5);
        pagedTable.setDataProvider((AbstractDataProvider)this.dataProvider);
        ((AsyncDataProvider)Mockito.verify((Object)this.dataProvider)).addDataDisplay((HasData)pagedTable);
    }

    @Test
    public void testDataGridFixedHeight() throws Exception {
        int PAGE_SIZE = 10;
        int EXPECTED_HEIGHT_PX = 386;
        PagedTable pagedTable = new PagedTable(10);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setHeight(Mockito.anyString());
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setHeight((String)Mockito.eq((Object)"386px"));
    }

    @Test
    public void testDataGridHeight() throws Exception {
        int PAGE_SIZE = 10;
        int ROWS = 2;
        int EXPECTED_HEIGHT_PX = 122;
        PagedTable pagedTable = new PagedTable(10, null, null, false, false, false, false);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        Mockito.when((Object)pagedTable.dataGrid.getRowCount()).thenReturn((Object)2);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setHeight(Mockito.anyString());
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setHeight((String)Mockito.eq((Object)"122px"));
    }

    @Test
    public void testDataGridSetHeightOnColumnChange() throws Exception {
        PagedTable pagedTable = new PagedTable(10, null, null, false, false, false, false);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        ((Scheduler)Mockito.doAnswer(invocation -> {
            Scheduler.ScheduledCommand cmd = (Scheduler.ScheduledCommand)invocation.getArguments()[0];
            cmd.execute();
            return null;
        }).when((Object)Scheduler.get())).scheduleDeferred((Scheduler.ScheduledCommand)Mockito.any());
        pagedTable.getColumnPicker().adjustColumnWidths();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid)).setHeight(Mockito.anyString());
    }

    @Test
    public void testDataGridFixedHeightOnColumnChange() throws Exception {
        PagedTable pagedTable = new PagedTable(10, null, null, false, false, false, true);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        ((Scheduler)Mockito.doAnswer(invocation -> {
            Scheduler.ScheduledCommand cmd = (Scheduler.ScheduledCommand)invocation.getArguments()[0];
            cmd.execute();
            return null;
        }).when((Object)Scheduler.get())).scheduleDeferred((Scheduler.ScheduledCommand)Mockito.any());
        pagedTable.getColumnPicker().adjustColumnWidths();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.never())).setHeight(Mockito.anyString());
    }

    @Test
    public void testLoadPageSizePreferencesResetsPageStart() throws Exception {
        int PAGE_SIZE = 10;
        PagedTable pagedTable = new PagedTable(10);
        pagedTable.dataGrid = (DataGrid)Mockito.spy((Object)pagedTable.dataGrid);
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)0))).setPageStart(0);
        pagedTable.loadPageSizePreferences();
        ((DataGrid)Mockito.verify((Object)pagedTable.dataGrid, (VerificationMode)Mockito.times((int)1))).setPageStart(0);
    }
}

