/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.PerspectiveDropDown;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectiveDropDownTest {
    @Mock
    ActivityBeansCache activityBeansCache;
    @Mock
    LiveSearchDropDown liveSearchDropDown;
    PerspectiveDropDown perspectiveDropDown;

    @Before
    public void setUp() {
        this.perspectiveDropDown = new PerspectiveDropDown(this.activityBeansCache, this.liveSearchDropDown);
        SyncBeanDef mock1 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock1.getName()).thenReturn((Object)"A");
        Mockito.when((Object)mock1.isAssignableTo(PerspectiveActivity.class)).thenReturn((Object)true);
        SyncBeanDef mock2 = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock2.getName()).thenReturn((Object)"B");
        Mockito.when((Object)mock2.isAssignableTo(PerspectiveActivity.class)).thenReturn((Object)true);
        Mockito.when((Object)this.activityBeansCache.getPerspectiveActivities()).thenReturn(Arrays.asList(mock1, mock2));
    }

    @Test
    public void testSearchAll() {
        this.perspectiveDropDown.searchService.search("", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)2L));
    }

    @Test
    public void testSearchItem() {
        this.perspectiveDropDown.searchService.search("A", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)1L));
        this.perspectiveDropDown.searchService.search("a", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)1L));
    }

    @Test
    public void testSearchEmpty() {
        this.perspectiveDropDown.searchService.search("x", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)0L));
    }

    @Test
    public void testExcludeItems() {
        HashSet<String> excluded = new HashSet<String>();
        excluded.add("A");
        this.perspectiveDropDown.setPerspectiveIdsExcluded(excluded);
        this.perspectiveDropDown.searchService.search("", -1, itemList -> {
            Assert.assertEquals((long)itemList.size(), (long)1L);
            Assert.assertEquals((Object)((LiveSearchEntry)itemList.get(0)).getKey(), (Object)"B");
        });
    }

    @Test
    public void testCustomNames() {
        this.perspectiveDropDown.setPerspectiveNameProvider(itemId -> "x");
        this.perspectiveDropDown.searchService.search("A", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)0L));
        this.perspectiveDropDown.searchService.search("x", -1, itemList -> Assert.assertEquals((long)itemList.size(), (long)2L));
    }
}

