/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.html.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.ext.widgets.table.client.DataGrid;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Image.class, Label.class, Text.class})
public class SimpleTableTest {
    @GwtMock
    DataGrid dataGridMock;
    protected CallerMock<UserPreferencesService> userPreferencesService;
    @Mock
    protected UserPreferencesService userPreferencesServiceMock;
    private SimpleTable simpleTable;
    private GridPreferencesStore gridPreferencesStore;

    @Before
    public void setupMocks() {
        this.simpleTable = new SimpleTable();
        this.gridPreferencesStore = new GridPreferencesStore(new GridGlobalPreferences("key", null, null));
        this.simpleTable.setGridPreferencesStore(this.gridPreferencesStore);
        this.userPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.simpleTable.setPreferencesService(this.userPreferencesService);
    }

    @Test
    public void testRedrawFlush() throws Exception {
        this.simpleTable = new SimpleTable();
        this.simpleTable.dataGrid = this.dataGridMock;
        this.simpleTable.redraw();
        ((DataGrid)Mockito.verify((Object)this.dataGridMock)).redraw();
        ((DataGrid)Mockito.verify((Object)this.dataGridMock)).flush();
    }

    @Test
    public void testSavePreferencesAfterColumnChangeByDefault() {
        this.simpleTable.afterColumnChangedHandler();
        Assert.assertTrue((boolean)this.simpleTable.isPersistingPreferencesOnChange());
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).saveUserPreferences((UserPreference)Mockito.any(UserPreference.class));
    }

    @Test
    public void testSavePreferencesAfterColumnChangeConf() {
        this.simpleTable.setPersistPreferencesOnChange(true);
        this.simpleTable.afterColumnChangedHandler();
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).saveUserPreferences((UserPreference)Mockito.any(UserPreference.class));
        this.simpleTable.setPersistPreferencesOnChange(false);
        this.simpleTable.afterColumnChangedHandler();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.userPreferencesServiceMock});
    }

    @Test
    public void testDefaultSavePreferencesUsingGlobalPreferencesKey() {
        String newKey = "newKey";
        this.gridPreferencesStore.setPreferenceKey(newKey);
        this.simpleTable.saveGridPreferences();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(UserPreference.class);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).saveUserPreferences((UserPreference)argumentCaptor.capture());
        Assert.assertEquals((Object)this.gridPreferencesStore.getGlobalPreferences().getKey(), (Object)((UserPreference)argumentCaptor.getValue()).getPreferenceKey());
        Assert.assertNotEquals((Object)newKey, (Object)((UserPreference)argumentCaptor.getValue()).getPreferenceKey());
        Assert.assertEquals((Object)UserPreferencesType.GRIDPREFERENCES, (Object)((UserPreference)argumentCaptor.getValue()).getType());
    }

    @Test
    public void testSaveUserPreferencesUsingPreferencesKey() {
        String newKey = "newKey";
        this.gridPreferencesStore.setPreferenceKey(newKey);
        this.simpleTable.saveGridToUserPreferences();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(UserPreference.class);
        ((UserPreferencesService)Mockito.verify((Object)this.userPreferencesServiceMock)).saveUserPreferences((UserPreference)argumentCaptor.capture());
        Assert.assertEquals((Object)newKey, (Object)((UserPreference)argumentCaptor.getValue()).getPreferenceKey());
        Assert.assertEquals((Object)UserPreferencesType.GRIDPREFERENCES, (Object)((UserPreference)argumentCaptor.getValue()).getType());
    }
}

