/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.breadcrumbs;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.dom.Element;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.ext.widgets.common.client.breadcrumbs.header.UberfireBreadcrumbsContainer;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.BreadcrumbPresenter;
import org.uberfire.ext.widgets.common.client.breadcrumbs.widget.DefaultBreadcrumbsPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class UberfireBreadcrumbsTest {
    @Mock
    private UberfireBreadcrumbsContainer uberfireBreadcrumbsContainer;
    @Mock
    private ManagedInstance<DefaultBreadcrumbsPresenter> breadcrumbsPresenters;
    @Mock
    private DefaultBreadcrumbsPresenter.View breadcrumbsPresenterView;
    @Mock
    private PlaceManager placeManager;
    private UberfireBreadcrumbs uberfireBreadcrumbs;
    private UberfireBreadcrumbs.View view;

    @Before
    public void setup() {
        ((ManagedInstance)Mockito.doAnswer(invocationOnMock -> new DefaultBreadcrumbsPresenter(this.breadcrumbsPresenterView)).when(this.breadcrumbsPresenters)).get();
        this.view = (UberfireBreadcrumbs.View)Mockito.mock(UberfireBreadcrumbs.View.class);
        this.uberfireBreadcrumbs = (UberfireBreadcrumbs)Mockito.spy((Object)new UberfireBreadcrumbs(this.uberfireBreadcrumbsContainer, this.breadcrumbsPresenters, this.placeManager, this.view){});
        this.uberfireBreadcrumbs.currentPerspective = "currentPerspective";
    }

    @Test
    public void createBreadcrumbsTest() {
        this.uberfireBreadcrumbs.createBreadcrumbs();
        ((UberfireBreadcrumbsContainer)Mockito.verify((Object)this.uberfireBreadcrumbsContainer)).init((HTMLElement)Matchers.any(HTMLElement.class));
    }

    @Test
    public void addToolbar() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addToolbar("myperspective", (Element)Mockito.mock(Element.class));
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
    }

    @Test
    public void addBreadcrumbs() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label2", (PlaceRequest)new DefaultPlaceRequest("screen2"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective2", "label4", (PlaceRequest)new DefaultPlaceRequest("screen4"));
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        Assert.assertEquals((long)2L, (long)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.size());
        Assert.assertEquals((long)2L, (long)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).size());
    }

    @Test
    public void clearBreadcrumbsTest() {
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addToolbar("myperspective", (Element)Mockito.mock(Element.class));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        Assert.assertFalse((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.clearBreadcrumbs("myperspective");
        Assert.assertTrue((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
    }

    @Test
    public void clearBreadcrumbsAndToolBarsTest() {
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addToolbar("myperspective", (Element)Mockito.mock(Element.class));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        Assert.assertFalse((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertFalse((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.clearBreadcrumbsAndToolBars("myperspective");
        Assert.assertTrue((boolean)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).isEmpty());
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.isEmpty());
    }

    @Test
    public void removeDeepLevelBreadcrumbsTest() {
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label2", (PlaceRequest)new DefaultPlaceRequest("screen2"));
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label3", (PlaceRequest)new DefaultPlaceRequest("screen3"));
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        this.uberfireBreadcrumbs.removeDeepLevelBreadcrumbsIfNecessary("myperspective", (DefaultBreadcrumbsPresenter)breadcrumbs.get(0));
        Assert.assertEquals((long)1L, (long)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).size());
    }

    @Test
    public void doesNotRemoveDeepLevelBreadcrumbsTest() {
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", () -> {}, false);
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label2", () -> {}, false);
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label3", () -> {}, false);
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        this.uberfireBreadcrumbs.removeDeepLevelBreadcrumbsIfNecessary("myperspective", (DefaultBreadcrumbsPresenter)breadcrumbs.get(0));
        Assert.assertEquals((long)3L, (long)((List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective")).size());
    }

    @Test
    public void generateBreadCrumbSelectCommandTest() {
        DefaultPlaceRequest placeRequest = new DefaultPlaceRequest("screen");
        Command command = (Command)Mockito.mock(Command.class);
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)placeRequest);
        List breadcrumbs = (List)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.get("myperspective");
        DefaultBreadcrumbsPresenter breadcrumb = (DefaultBreadcrumbsPresenter)breadcrumbs.get(0);
        this.uberfireBreadcrumbs.generateBreadCrumbSelectCommand("myperspective", breadcrumb, (PlaceRequest)placeRequest, command).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo((PlaceRequest)Mockito.eq((Object)placeRequest), (HasWidgets)Matchers.any(HasWidgets.class));
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void getViewShouldAddInnerBreadcrumbsTest() {
        List<BreadcrumbPresenter> breadcrumbs = Arrays.asList((BreadcrumbPresenter)Mockito.mock(DefaultBreadcrumbsPresenter.class), (BreadcrumbPresenter)Mockito.mock(DefaultBreadcrumbsPresenter.class));
        this.uberfireBreadcrumbs.breadcrumbsPerPerspective.put("myperspective", breadcrumbs);
        this.uberfireBreadcrumbs.breadcrumbsToolBarPerPerspective.put("myperspective", Mockito.mock(Element.class));
        this.uberfireBreadcrumbs.getView();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view)).clear();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addBreadcrumb((UberElemental)Matchers.any(UberElemental.class));
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.getView();
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addBreadcrumb((UberElemental)Matchers.any(UberElemental.class));
        ((UberfireBreadcrumbs.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addBreadcrumbToolbar((Element)Matchers.any(Element.class));
    }

    @Test
    public void addBreadcrumbAssociatedWithACommandTest() {
        Command command = (Command)Mockito.mock(Command.class);
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", command);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.uberfireBreadcrumbs)).addBreadCrumb("myperspective", "label", null, command, true);
    }

    @Test
    public void addBreadcrumbAssociatedWithAPlaceRequestTest() {
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.uberfireBreadcrumbs)).addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"), null, true);
    }

    @Test
    public void addBreadcrumbAssociatedWithAPlaceRequestWithACommandTest() {
        Command command = (Command)Mockito.mock(Command.class);
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"), command);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.uberfireBreadcrumbs)).addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"), command, true);
    }

    @Test
    public void updateBreadcrumbsContainerTest() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.addBreadCrumb("myperspective", "label", (PlaceRequest)new DefaultPlaceRequest("screen"));
        ((UberfireBreadcrumbsContainer)Mockito.verify((Object)this.uberfireBreadcrumbsContainer)).enable();
    }

    @Test
    public void updateBreadcrumbsWithNoBreadcrumbsContainerTest() {
        Assert.assertTrue((boolean)this.uberfireBreadcrumbs.breadcrumbsPerPerspective.isEmpty());
        this.uberfireBreadcrumbs.currentPerspective = "myperspective";
        this.uberfireBreadcrumbs.updateBreadcrumbsContainer();
        ((UberfireBreadcrumbsContainer)Mockito.verify((Object)this.uberfireBreadcrumbsContainer)).disable();
    }
}

