/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.dropdown.EntryCreationEditor;
import org.uberfire.ext.widgets.common.client.dropdown.EntryCreationLiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchCallback;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDownView;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchEntry;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectionHandler;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectorItem;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.SingleLiveSearchSelectionHandler;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractEntryCreationLiveSearchServiceTest<EDITOR extends EntryCreationEditor> {
    protected static final String VALUE = "value";
    protected EDITOR editor;
    @Mock
    protected EntryCreationLiveSearchService searchService;
    @Mock
    protected SingleLiveSearchSelectionHandler searchSelectionHandler;
    @Mock
    protected LiveSearchDropDownView view;
    @Mock
    private ManagedInstance<LiveSearchSelectorItem> selectorItems;
    protected LiveSearchDropDown dropDown;
    protected ParameterizedCommand<LiveSearchEntry> onAddCommand;
    protected Command onCancelCommand;

    @Before
    public void init() {
        Mockito.when((Object)this.selectorItems.get()).thenAnswer(invocationOnMock -> (LiveSearchSelectorItem)Mockito.mock(LiveSearchSelectorItem.class));
        this.editor = (EntryCreationEditor)Mockito.mock(this.getEditorType());
        Mockito.when((Object)this.searchService.getEditor()).thenReturn(this.editor);
        this.dropDown = (LiveSearchDropDown)Mockito.spy((Object)new LiveSearchDropDown((LiveSearchDropDown.View)this.view, this.selectorItems));
    }

    @Test
    public void testEditorAddNewEntryAction() {
        this.startTest();
        LiveSearchEntry entry = new LiveSearchEntry((Object)VALUE, VALUE);
        this.onAddCommand.execute((Object)entry);
        ((LiveSearchDropDown)Mockito.verify((Object)this.dropDown)).addNewItem(entry);
        ((SingleLiveSearchSelectionHandler)Mockito.verify((Object)this.searchSelectionHandler)).selectItem((LiveSearchSelectorItem)Matchers.any());
        ((LiveSearchDropDown)Mockito.verify((Object)this.dropDown)).search((String)Matchers.any());
        ((LiveSearchDropDown)Mockito.verify((Object)this.dropDown)).doSearch((String)Matchers.any());
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).searchInProgress((String)Matchers.any());
        ((EntryCreationLiveSearchService)Mockito.verify((Object)this.searchService)).search(Matchers.anyString(), Matchers.anyInt(), (LiveSearchCallback)Matchers.any());
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).restoreFooter();
    }

    protected void startTest() {
        this.dropDown.init((LiveSearchService)this.searchService, (LiveSearchSelectionHandler)this.searchSelectionHandler);
        ((LiveSearchDropDownView)Mockito.verify((Object)this.view)).setNewInstanceEnabled(true);
        ArgumentCaptor onAddCommandCaptor = ArgumentCaptor.forClass(ParameterizedCommand.class);
        ArgumentCaptor onCancelCommandCaptor = ArgumentCaptor.forClass(Command.class);
        ((EntryCreationEditor)Mockito.verify(this.editor)).init((ParameterizedCommand)onAddCommandCaptor.capture(), (Command)onCancelCommandCaptor.capture());
        this.onAddCommand = (ParameterizedCommand)onAddCommandCaptor.getValue();
        this.onCancelCommand = (Command)onCancelCommandCaptor.getValue();
        Assert.assertNotNull(this.onAddCommand);
        Assert.assertNotNull((Object)this.onCancelCommand);
        this.dropDown.showNewItem();
    }

    abstract Class<EDITOR> getEditorType();
}

