/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.dropdown;

import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchSelectorItem;
import org.uberfire.ext.widgets.common.client.dropdown.MultipleLiveSearchSelectionHandler;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class MultipleLiveSearchSelectionHandlerTest {
    private String SELECTED_ITEM_TEXT = "selectedItem";
    @Mock
    private Command callback;
    @Spy
    private MultipleLiveSearchSelectionHandler<String> handler;
    private CommonConstants constants;

    @Before
    public void init() {
        GwtMockito.initMocks((Object)this);
        System.out.println(CommonConstants.INSTANCE.liveSearchElementsSelected(2));
        this.handler.setLiveSearchSelectionCallback(this.callback);
    }

    @Test
    public void testRegisterItemWithoutSelectedValue() {
        LiveSearchSelectorItem item = this.createItem("any");
        this.handler.registerItem(item);
        ((LiveSearchSelectorItem)Mockito.verify((Object)item, (VerificationMode)Mockito.never())).select();
        ((LiveSearchSelectorItem)Mockito.verify((Object)item, (VerificationMode)Mockito.times((int)1))).setSelectionCallback((Command)Matchers.any());
        ((LiveSearchSelectorItem)Mockito.verify((Object)item, (VerificationMode)Mockito.times((int)1))).setMultipleSelection(true);
        this.checkHandlerSelectedValue(null);
        Assert.assertEquals(null, (Object)this.handler.getDropDownMenuHeader());
    }

    @Test
    public void testRegisterIItemWithSelectedValue() {
        LiveSearchSelectorItem selectedItem = this.doTestSelectItem();
        LiveSearchSelectorItem secondItem = this.createItem(this.SELECTED_ITEM_TEXT);
        this.handler.registerItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)selectedItem, (VerificationMode)Mockito.atLeast((int)1))).getKey();
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem, (VerificationMode)Mockito.times((int)2))).getKey();
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).select();
        this.checkHandlerSelectedValue(this.SELECTED_ITEM_TEXT);
        Assert.assertEquals((Object)this.SELECTED_ITEM_TEXT, (Object)this.handler.getDropDownMenuHeader());
    }

    @Test
    public void testSelectItem() {
        this.doTestSelectItem();
        Assert.assertEquals((long)1L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)this.SELECTED_ITEM_TEXT, (Object)this.handler.getDropDownMenuHeader());
    }

    @Test
    public void testSelectMultipleItems() {
        this.handler.setMaxDropDownTextItems(3);
        LiveSearchSelectorItem firstItem = this.createItem("a");
        this.handler.registerItem(firstItem);
        LiveSearchSelectorItem secondItem = this.createItem("b");
        this.handler.registerItem(secondItem);
        LiveSearchSelectorItem thirdItem = this.createItem("c");
        this.handler.registerItem(thirdItem);
        LiveSearchSelectorItem fourthItem = this.createItem("d");
        this.handler.registerItem(fourthItem);
        this.handler.selectKey((Object)"a");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).selectItem(firstItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)firstItem)).select();
        ((Command)Mockito.verify((Object)this.callback)).execute();
        this.checkHandlerSelectedValue("a");
        Assert.assertEquals((long)1L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"a", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"b");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).selectItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).select();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)2))).execute();
        this.checkHandlerSelectedValue("b");
        Assert.assertEquals((long)2L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"a & b", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"c");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).selectItem(thirdItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)thirdItem)).select();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)3))).execute();
        this.checkHandlerSelectedValue("c");
        Assert.assertEquals((long)3L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"a, b & c", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"d");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)1))).selectItem(fourthItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)fourthItem)).select();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)4))).execute();
        this.checkHandlerSelectedValue("d");
        Assert.assertEquals((long)4L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"liveSearchElementsSelected(4)", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"a");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)2))).selectItem(firstItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)firstItem)).reset();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)5))).execute();
        Assert.assertEquals((long)3L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"b, c & d", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"b");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)2))).selectItem(secondItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)secondItem)).reset();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)6))).execute();
        Assert.assertEquals((long)2L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"c & d", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"c");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)2))).selectItem(thirdItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)thirdItem)).reset();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)7))).execute();
        Assert.assertEquals((long)1L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"d", (Object)this.handler.getDropDownMenuHeader());
        this.handler.selectKey((Object)"d");
        ((MultipleLiveSearchSelectionHandler)Mockito.verify(this.handler, (VerificationMode)Mockito.times((int)2))).selectItem(fourthItem);
        ((LiveSearchSelectorItem)Mockito.verify((Object)fourthItem)).reset();
        ((Command)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.times((int)8))).execute();
        Assert.assertEquals((long)0L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals(null, (Object)this.handler.getDropDownMenuHeader());
    }

    @Test
    public void testClearSelection() {
        LiveSearchSelectorItem firstItem = this.createItem("a");
        this.handler.registerItem(firstItem);
        LiveSearchSelectorItem secondItem = this.createItem("b");
        this.handler.registerItem(secondItem);
        LiveSearchSelectorItem thirdItem = this.createItem("c");
        this.handler.registerItem(thirdItem);
        LiveSearchSelectorItem fourthItem = this.createItem("d");
        this.handler.registerItem(fourthItem);
        this.handler.selectKey((Object)"a");
        this.handler.selectKey((Object)"b");
        this.handler.selectKey((Object)"c");
        this.handler.selectKey((Object)"d");
        Assert.assertEquals((long)4L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals((Object)"a, b, c & d", (Object)this.handler.getDropDownMenuHeader());
        this.handler.clearSelection();
        Assert.assertEquals((long)0L, (long)this.handler.getSelectedValues().size());
        Assert.assertEquals(null, (Object)this.handler.getDropDownMenuHeader());
    }

    protected LiveSearchSelectorItem doTestSelectItem() {
        LiveSearchSelectorItem item = this.createItem(this.SELECTED_ITEM_TEXT);
        this.handler.registerItem(item);
        this.handler.selectItem(item);
        ((LiveSearchSelectorItem)Mockito.verify((Object)item)).select();
        this.checkHandlerSelectedValue(this.SELECTED_ITEM_TEXT);
        Assert.assertEquals((Object)this.SELECTED_ITEM_TEXT, (Object)this.handler.getDropDownMenuHeader());
        ((Command)Mockito.verify((Object)this.callback)).execute();
        return item;
    }

    private LiveSearchSelectorItem createItem(String value) {
        LiveSearchSelectorItem item = (LiveSearchSelectorItem)Mockito.mock(LiveSearchSelectorItem.class);
        Mockito.when((Object)item.getKey()).thenReturn((Object)value);
        Mockito.when((Object)item.getValue()).thenReturn((Object)value);
        return item;
    }

    private void checkHandlerSelectedValue(String value) {
        if (value != null) {
            Assert.assertTrue((boolean)this.handler.getSelectedValues().contains(value));
        } else {
            Assert.assertTrue((boolean)this.handler.getSelectedValues().isEmpty());
        }
    }
}

