/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDivider;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDividerView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeader;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeaderView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIcon;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class MenuItemFactoryTest {
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewHeaderProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewWithIconProducer;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewDividerProducer;
    private MenuItemFactory menuItemFactory;
    private Set<MenuItemView> menuItemFactoryViewMocks = new HashSet<MenuItemView>();

    @Before
    public void setup() {
        this.menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        this.menuItemFactoryViewMocks.clear();
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)ArgumentMatchers.any(Annotation.class)})).thenAnswer(o -> {
            Annotation a = (Annotation)o.getArguments()[0];
            if (a.annotationType().equals(MenuItemHeader.class)) {
                return this.menuItemViewHeaderProducer;
            }
            if (a.annotationType().equals(MenuItemWithIcon.class)) {
                return this.menuItemViewWithIconProducer;
            }
            if (a.annotationType().equals(MenuItemDivider.class)) {
                return this.menuItemViewDividerProducer;
            }
            throw new IllegalArgumentException("Unexpected MenuItemView");
        });
        Mockito.when((Object)this.menuItemViewHeaderProducer.get()).then(invocation -> {
            MenuItemHeaderView v = (MenuItemHeaderView)Mockito.mock(MenuItemHeaderView.class);
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
        Mockito.when((Object)this.menuItemViewWithIconProducer.get()).then(invocation -> {
            MenuItemWithIconView v = (MenuItemWithIconView)Mockito.mock(MenuItemWithIconView.class);
            ((MenuItemWithIconView)Mockito.doCallRealMethod().when((Object)v)).onClickListItem((ClickEvent)ArgumentMatchers.any(ClickEvent.class));
            ((MenuItemWithIconView)Mockito.doCallRealMethod().when((Object)v)).setClickHandler((ClickHandler)ArgumentMatchers.any(ClickHandler.class));
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
        Mockito.when((Object)this.menuItemViewDividerProducer.get()).then(invocation -> {
            MenuItemDividerView v = (MenuItemDividerView)Mockito.mock(MenuItemDividerView.class);
            this.menuItemFactoryViewMocks.add((MenuItemView)v);
            return v;
        });
    }

    @Test
    public void checkMenuItemHeaderConstruction() {
        MenuItemFactory.MenuItemViewHolder mih = this.menuItemFactory.makeMenuItemHeader("caption");
        Assert.assertNotNull((Object)mih);
        Assert.assertNotNull((Object)mih.getMenuItem());
        Assert.assertNotNull((Object)mih.getMenuItemView());
    }

    @Test
    public void checkMenuItemWithIconConstruction() {
        Command c = (Command)Mockito.mock(Command.class);
        MenuItemFactory.MenuItemViewHolder mih = this.menuItemFactory.makeMenuItemWithIcon("caption", c);
        Assert.assertNotNull((Object)mih);
        Assert.assertNotNull((Object)mih.getMenuItem());
        Assert.assertNotNull((Object)mih.getMenuItemView());
    }

    @Test
    public void checkMenuItemDividerConstruction() {
        MenuItemFactory.MenuItemViewHolder mih = this.menuItemFactory.makeMenuItemDivider();
        Assert.assertNotNull((Object)mih);
        Assert.assertNotNull((Object)mih.getMenuItem());
        Assert.assertNotNull((Object)mih.getMenuItemView());
    }

    @Test
    public void checkMenuItemWithIconEnabled() {
        Command c = (Command)Mockito.mock(Command.class);
        MenuItemFactory.MenuItemViewHolder mih = this.menuItemFactory.makeMenuItemWithIcon("caption", c);
        mih.getMenuItem().setEnabled(true);
        ((MenuItemWithIconView)Mockito.verify((Object)mih.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)true));
        ((MenuItemWithIconView)mih.getMenuItemView()).onClickListItem((ClickEvent)Mockito.mock(ClickEvent.class));
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void checkMenuItemWithIconDisabled() {
        Command c = (Command)Mockito.mock(Command.class);
        MenuItemFactory.MenuItemViewHolder mih = this.menuItemFactory.makeMenuItemWithIcon("caption", c);
        mih.getMenuItem().setEnabled(false);
        ((MenuItemWithIconView)Mockito.verify((Object)mih.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)false));
        ((MenuItemWithIconView)mih.getMenuItemView()).onClickListItem((ClickEvent)Mockito.mock(ClickEvent.class));
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.never())).execute();
    }
}

