/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.select.SelectComponent;
import org.uberfire.ext.widgets.common.client.select.SelectOption;
import org.uberfire.ext.widgets.common.client.select.SelectOptionComponent;
import org.uberfire.ext.widgets.common.client.select.SelectOptionImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class SelectComponentTest {
    @Mock
    private SelectComponent.View view;
    @Mock
    private ManagedInstance<SelectOptionComponent> selectOptionComponents;
    private SelectComponent component;
    private SelectOption option1;
    @Mock
    private Consumer<SelectOption> callback;
    @Mock
    private SelectOptionComponent selectOptionComponent;

    @Before
    public void setUp() {
        this.option1 = new SelectOptionImpl("FIRST", "first");
        this.component = (SelectComponent)Mockito.spy((Object)new SelectComponent(this.view, this.selectOptionComponents));
        Mockito.when((Object)this.selectOptionComponents.get()).thenReturn((Object)this.selectOptionComponent);
        this.component.init();
    }

    @Test
    public void testSetup() {
        this.component.setup(Arrays.asList(this.option1), this.callback);
        ((SelectOptionComponent)Mockito.verify((Object)this.selectOptionComponent)).initialize((SelectOption)Mockito.eq((Object)this.option1), (Consumer)Mockito.any());
    }

    @Test
    public void testEmptySelectOptions() {
        this.component.setup(Arrays.asList(new SelectOption[0]), this.callback);
        ((SelectOptionComponent)Mockito.verify((Object)this.selectOptionComponent, (VerificationMode)Mockito.never())).initialize((SelectOption)Mockito.eq((Object)this.option1), (Consumer)Mockito.any());
    }

    @Test
    public void testSelectOption() {
        ArrayList consumer = new ArrayList();
        ((SelectOptionComponent)Mockito.doAnswer(invocation -> {
            consumer.add((Consumer)invocation.getArguments()[1]);
            return null;
        }).when((Object)this.selectOptionComponent)).initialize((SelectOption)Mockito.any(), (Consumer)Mockito.any());
        ((SelectOptionComponent)Mockito.doAnswer(invocation -> {
            ((Consumer)consumer.get(0)).accept(this.option1);
            return null;
        }).when((Object)this.selectOptionComponent)).select();
        this.component.setup(Arrays.asList(this.option1), this.callback);
        this.selectOptionComponent.select();
        ((SelectComponent)Mockito.verify((Object)this.component, (VerificationMode)Mockito.times((int)1))).deactivateAll();
        ((Consumer)Mockito.verify(this.callback, (VerificationMode)Mockito.times((int)1))).accept(this.option1);
        ((SelectOptionComponent)Mockito.verify((Object)this.selectOptionComponent, (VerificationMode)Mockito.times((int)1))).activate();
        ((SelectComponent.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.atLeastOnce())).setSelected((String)Mockito.eq((Object)this.option1.getName()));
    }
}

