/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.widgets.common.client.common.NumericIntegerTextBox;

@RunWith(value=GwtMockitoTestRunner.class)
public class NumericIntegerTextBoxTest {
    private NumericIntegerTextBox numericIntegerTextBox;

    @Before
    public void setUp() throws Exception {
        this.numericIntegerTextBox = new NumericIntegerTextBox();
    }

    @Test
    public void testDefaultValue() {
        Assertions.assertThat((String)this.numericIntegerTextBox.makeValidValue("")).isEqualTo("0");
        Assertions.assertThat((String)this.numericIntegerTextBox.makeValidValue("123")).isEqualTo("0");
        Assertions.assertThat((String)this.numericIntegerTextBox.makeValidValue("-123")).isEqualTo("0");
        Assertions.assertThat((String)this.numericIntegerTextBox.makeValidValue("abcd")).isEqualTo("0");
    }

    @Test
    public void testIsValidValue_ValidValues() {
        Assertions.assertThat((boolean)this.numericIntegerTextBox.isValidValue("123", false)).isTrue();
        Assertions.assertThat((boolean)this.numericIntegerTextBox.isValidValue("-123", false)).isTrue();
    }

    @Test
    public void testIsValidValue_InvalidValues() {
        Assertions.assertThat((boolean)this.numericIntegerTextBox.isValidValue("123.0", false)).isFalse();
        Assertions.assertThat((boolean)this.numericIntegerTextBox.isValidValue("abcd", false)).isFalse();
        Assertions.assertThat((boolean)this.numericIntegerTextBox.isValidValue("!", false)).isFalse();
    }
}

