/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.properties.editor.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@Portable
public class PropertyEditorFieldInfo {
    private String label;
    private String currentStringValue;
    private String originalValue;
    private PropertyEditorCategory category;
    private PropertyEditorType type;
    private List<String> comboValues;
    private int priority = Integer.MAX_VALUE;
    private List<PropertyFieldValidator> validators = new ArrayList<PropertyFieldValidator>();
    private String key;
    private boolean isRemovalSupported = false;
    private String helpHeading;
    private String helpText;

    public PropertyEditorFieldInfo() {
    }

    public PropertyEditorFieldInfo(String label, PropertyEditorType type) {
        this.label = (String)PortablePreconditions.checkNotNull((String)"label", (Object)label);
        this.originalValue = this.currentStringValue;
        this.type = (PropertyEditorType)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
        this.validators.addAll(type.getValidators());
    }

    public PropertyEditorFieldInfo(String label, String currentStringValue, PropertyEditorType type) {
        this.label = (String)PortablePreconditions.checkNotNull((String)"label", (Object)label);
        this.currentStringValue = (String)PortablePreconditions.checkNotNull((String)"currentStringValue", (Object)currentStringValue);
        this.originalValue = currentStringValue;
        this.type = (PropertyEditorType)((Object)PortablePreconditions.checkNotNull((String)"type", (Object)((Object)type)));
        this.validators.addAll(type.getValidators());
    }

    public PropertyEditorFieldInfo withKey(String key) {
        this.key = (String)PortablePreconditions.checkNotNull((String)"key", (Object)key);
        return this;
    }

    public PropertyEditorFieldInfo withComboValues(List<String> comboValues) {
        this.comboValues = (List)PortablePreconditions.checkNotNull((String)"comboValues", comboValues);
        return this;
    }

    public PropertyEditorFieldInfo withPriority(int priority) {
        this.priority = (Integer)PortablePreconditions.checkNotNull((String)"priority", (Object)priority);
        return this;
    }

    public PropertyEditorFieldInfo withHelpInfo(String helpHeading, String helpText) {
        this.helpHeading = helpHeading;
        this.helpText = helpText;
        return this;
    }

    public PropertyEditorFieldInfo withValidators(PropertyFieldValidator ... validators) {
        PortablePreconditions.checkNotNull((String)"validators", (Object)validators);
        this.validators.clear();
        for (PropertyFieldValidator field : validators) {
            this.validators.add(field);
        }
        return this;
    }

    public PropertyEditorFieldInfo withRemovalSupported(boolean isRemovalSupported) {
        this.isRemovalSupported = isRemovalSupported;
        return this;
    }

    public void undo() {
        this.currentStringValue = this.originalValue;
    }

    public List<String> getComboValues() {
        return this.comboValues;
    }

    public PropertyEditorType getType() {
        return this.type;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getCurrentStringValue() {
        return this.currentStringValue;
    }

    public boolean isRemovalSupported() {
        return this.isRemovalSupported;
    }

    public boolean hasHelpInfo() {
        return this.helpHeading != null && this.helpText != null;
    }

    public void setCurrentStringValue(String currentStringValue) {
        this.currentStringValue = currentStringValue;
    }

    public void setPropertyEditorCategory(PropertyEditorCategory category) {
        this.category = category;
    }

    public String getLabel() {
        return this.label;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<PropertyFieldValidator> getValidators() {
        return this.validators;
    }

    public String getEventId() {
        return this.category.getIdEvent();
    }

    public String getKey() {
        return this.key;
    }

    public String getHelpHeading() {
        return this.helpHeading;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String toString() {
        return "PropertyEditorFieldInfo{label=" + this.label + ", currentStringValue=" + this.currentStringValue + ", originalValue=" + this.originalValue + ", category=" + this.category + ", type=" + (Object)((Object)this.type) + ", comboValues=" + this.comboValues + ", priority=" + this.priority + ", validators=" + this.validators + ", key=" + this.key + '}';
    }
}

